"""
Gas mixtures supported by OpenSCM Units
"""

_nan = float("nan")

MIXTURES = {
    # note that CFC400 can also be a 60 / 40 split and the standard says it MUST be
    # specified, but it is almost never specified and 50/50 seems to be more common
    "CFC400": {"CFC12": [50, _nan, _nan], "CFC114": [50, _nan, _nan]},
    "HCFC401a": {
        "HCFC22": [53, 2, -2],
        "HFC152a": [13, 0.5, -1.5],
        "HCFC124": [34, 1, -1],
    },
    "HCFC401b": {
        "HCFC22": [61, 2, -2],
        "HFC152a": [11, 0.5, -1.5],
        "HCFC124": [28, 1, -1],
    },
    "HCFC401c": {
        "HCFC22": [33, 2, -2],
        "HFC152a": [15, 0.5, -1.5],
        "HCFC124": [52, 1, -1],
    },
    "HCFC402a": {"HFC125": [60, 2, -2], "C3H8": [2, 0.1, -1], "HCFC22": [38, 2, -2]},
    "HCFC402b": {"HFC125": [38, 2, -2], "C3H8": [2, 0.1, -1], "HCFC22": [60, 2, -2]},
    "HCFC403a": {"C3H8": [5, 0.2, -2], "HCFC22": [75, 2, -2], "C3F8": [20, 2, -2]},
    "HCFC403b": {"C3H8": [5, 0.2, -2], "HCFC22": [56, 2, -2], "C3F8": [39, 2, -2]},
    "HFC404a": {"HFC125": [44, 2, -2], "HFC143a": [52, 1, -1], "HFC134a": [4, 2, -2]},
    # HCFC405a has additional composition tolerances for the sum of 152a and 142b, which
    # can't be represented in this format
    "HCFC405a": {
        "HCFC22": [45, 2, -2],
        "HFC152": [7, 1, -1],
        "HCFC142b": [5.5, 1, -1],
        "cC4F8": [42.5, 2, -2],
    },
    "HCFC406a": {"HCFC22": [55, 2, -2], "HC600a": [4, 1, -1], "HCFC142b": [41, 1, -1]},
    "HFC407a": {"HFC32": [20, 2, -2], "HFC125": [40, 2, -2], "HFC134a": [40, 2, -2]},
    "HFC407b": {"HFC32": [10, 2, -2], "HFC125": [70, 2, -2], "HFC134a": [20, 2, -2]},
    "HFC407c": {"HFC32": [23, 2, -2], "HFC125": [25, 2, -2], "HFC134a": [52, 2, -2]},
    "HFC407d": {"HFC32": [15, 2, -2], "HFC125": [15, 2, -2], "HFC134a": [70, 2, -2]},
    "HFC407e": {"HFC32": [25, 2, -2], "HFC125": [15, 2, -2], "HFC134a": [60, 2, -2]},
    "HFC407f": {"HFC32": [30, 2, -2], "HFC125": [30, 2, -2], "HFC134a": [40, 2, -2]},
    "HFC407g": {
        "HFC32": [2.5, 0.5, -0.5],
        "HFC125": [2.5, 0.5, -0.5],
        "HFC134a": [95, 1, -1],
    },
    "HFC407h": {
        "HFC32": [32.5, 1, -1],
        "HFC125": [15, 1, -1],
        "HFC134a": [52.5, 2, -2],
    },
    "HFC407i": {"HFC32": [19.5, 1, -2], "HFC125": [8.5, 2, -1], "HFC134a": [72, 2, -2]},
    "HCFC408a": {"HFC125": [7, 2, -2], "HFC143a": [46, 1, -1], "HCFC22": [47, 2, -2]},
    "HCFC409a": {
        "HCFC22": [60, 2, -2],
        "HCFC124": [25, 2, -2],
        "HCFC142b": [15, 1, -1],
    },
    "HCFC409b": {
        "HCFC22": [65, 2, -2],
        "HCFC124": [25, 2, -2],
        "HCFC142b": [10, 1, -1],
    },
    "HFC410a": {"HFC32": [50, 0.5, -1.5], "HFC125": [50, 1.5, -0.5]},
    "HFC410b": {"HFC32": [45, 1, -1], "HFC125": [55, 1, -1]},
    "HCFO411a": {
        "HO1270": [1.5, 0, -1],
        "HCFC22": [87.5, 2, 0],
        "HFC152a": [11, 0, -1],
    },
    "HCFO411b": {"HO1270": [3, 0, -1], "HCFC22": [94, 2, 0], "HFC152a": [3, 0, -1]},
    "HCFC412a": {"HCFC22": [70, 2, -2], "C3F8": [5, 2, -2], "HCFC142b": [25, 1, -1]},
    "HFC413a": {"C3F8": [9, 1, -1], "HFC134a": [88, 2, -2], "HC600a": [3, 0, -1]},
    "HCFC414a": {
        "HCFC22": [51, 2, -2],
        "HCFC124": [28.5, 2, -2],
        "HC600a": [4, 0.5, -0.5],
        "HCFC142b": [16.5, 0.5, -1],
    },
    "HCFC414b": {
        "HCFC22": [50, 2, -2],
        "HCFC124": [39, 2, -2],
        "HC600a": [1.5, 0.5, -0.5],
        "HCFC142b": [9.5, 0.5, -1],
    },
    "HCFC415a": {"HCFC22": [82, 1, -1], "HFC152a": [18, 1, -1]},
    "HCFC415b": {"HCFC22": [25, 1, -1], "HFC152a": [75, 1, -1]},
    "HCFC416a": {
        "HFC134a": [59, 0.5, -1],
        "HCFC124": [39.5, 1, -0.5],
        "HC600": [1.5, 1, -0.2],
    },
    "HFC417a": {
        "HFC125": [46.6, 1.1, -1.1],
        "HFC134a": [50, 1, -1],
        "HC600": [3.4, 0.1, -0.4],
    },
    "HFC417b": {
        "HFC125": [79, 1, -1],
        "HFC134a": [18.3, 1, -1],
        "HC600": [2.7, 0.1, -0.5],
    },
    "HFC417c": {
        "HFC125": [19.5, 1, -1],
        "HFC134a": [78.8, 1, -1],
        "HC600": [1.7, 0.1, -0.5],
    },
    "HCFC418a": {
        "C3H8": [1.5, 0.5, -0.5],
        "HCFC22": [96, 1, -1],
        "HFC152a": [2.5, 0.5, -0.5],
    },
    "HFC419a": {"HFC125": [77, 1, -1], "HFC134a": [19, 1, -1], "HCE170": [4, 1, -1]},
    "HFC419b": {
        "HFC125": [48.5, 1, -1],
        "HFC134a": [48, 1, -1],
        "HCE170": [3.5, 0.5, -0.5],
    },
    "HCFC420a": {"HFC134a": [88, 1, 0], "HCFC142b": [12, 0, -1]},
    "HFC421a": {"HFC125": [58, 1, -1], "HFC134a": [42, 1, -1]},
    "HFC421b": {"HFC125": [85, 1, -1], "HFC134a": [15, 1, -1]},
    "HFC422a": {
        "HFC125": [85.1, 1, -1],
        "HFC134a": [11.5, 1, -1],
        "HC600a": [3.4, 0.1, -0.4],
    },
    "HFC422b": {
        "HFC125": [55, 1, -1],
        "HFC134a": [42, 1, -1],
        "HC600a": [3, 0.1, -0.5],
    },
    "HFC422c": {
        "HFC125": [82, 1, -1],
        "HFC134a": [15, 1, -1],
        "HC600a": [3, 0.1, -0.5],
    },
    "HFC422d": {
        "HFC125": [65.1, 0.9, -1.1],
        "HFC134a": [31.5, 1, -1],
        "HC600a": [3.4, 0.1, -0.4],
    },
    "HFC422e": {
        "HFC125": [58, 1, -1],
        "HFC134a": [39.3, 1.7, -1.3],
        "HC600a": [2.7, 0.3, -0.2],
    },
    "HFC423a": {"HFC134a": [52.5, 1, -1], "HFC227ea": [47.5, 1, -1]},
    "HFC424a": {
        "HFC125": [50.5, 1, -1],
        "HFC134a": [47.0, 1, -1],
        "HC600a": [0.9, 0.1, -0.2],
        "HC600": [1.0, 0.1, -0.2],
        "HC601a": [0.6, 0.1, -0.2],
    },
    "HFC425a": {
        "HFC32": [18.5, 0.5, -0.5],
        "HFC134a": [69.5, 0.5, -0.5],
        "HFC227ea": [12, 0.5, -0.5],
    },
    "HFC426a": {
        "HFC125": [5.1, 1, -1],
        "HFC134a": [93, 1, -1],
        "HC600": [1.3, 0.1, -0.2],
        "HC601a": [0.6, 0.1, -0.2],
    },
    "HFC427a": {
        "HFC32": [15, 2, -2],
        "HFC125": [25, 2, -2],
        "HFC143a": [10, 2, -2],
        "HFC134a": [50, 2, -2],
    },
    "HFC428a": {
        "HFC125": [77.5, 1, -1],
        "HFC143a": [20, 1, -1],
        "C3H8": [0.6, 0.1, -0.2],
        "HC600a": [1.9, 0.1, -0.2],
    },
    "HFC429a": {"HCE170": [60, 1, -1], "HFC152a": [10, 1, -1], "HC600a": [30, 1, -1]},
    "HFC430a": {"HFC152a": [76, 1, -1], "HC600a": [24, 1, -1]},
    "HFC431a": {"C3H8": [71, 1, -1], "HFC152a": [29, 1, -1]},
    "HO432a": {"HO1270": [80, 1, -1], "HCE170": [20, 1, -1]},
    "HO433a": {"HO1270": [30, 1, -1], "C3H8": [70, 1, -1]},
    "HO433b": {"HO1270": [5, 1, -1], "C3H8": [95, 1, -1]},
    "HO433c": {"HO1270": [25, 1, -1], "C3H8": [75, 1, -1]},
    "HFC434a": {
        "HFC125": [63.2, 1, -1],
        "HFC143a": [18, 1, -1],
        "HFC134a": [16, 1, -1],
        "HC600a": [2.8, 0.1, -0.2],
    },
    "HFC435a": {"HCE170": [80, 1, -1], "HFC152a": [20, 1, -1]},
    "HC436a": {"C3H8": [56, 1, -1], "HC600a": [44, 1, -1]},
    "HC436b": {"C3H8": [52, 1, -1], "HC600a": [48, 1, -1]},
    "HC436c": {"C3H8": [95, 1.2, -1.2], "HC600a": [5, 1.2, -1.2]},
    "HFC437a": {
        "HFC125": [19.5, 0.5, -1.8],
        "HFC134a": [78.5, 1.5, -0.7],
        "HC600": [1.4, 0.1, -0.2],
        "HC601": [0.6, 0.1, -0.2],
    },
    "HFC438a": {
        "HFC32": [8.5, 0.5, -1.5],
        "HFC125": [45, 1.5, -1.5],
        "HFC134a": [44.2, 1.5, -1.5],
        "HC600": [1.7, 0.1, -0.2],
        "HC601a": [0.6, 0.1, -0.2],
    },
    "HFC439a": {"HFC32": [50, 1, -1], "HFC125": [47, 1, -1], "HC600a": [3, 0.5, -0.5]},
    "HFC440a": {
        "C3H8": [0.6, 0.1, -0.1],
        "HFC134a": [1.6, 0.6, -0.6],
        "HFC152a": [97.8, 0.5, -0.5],
    },
    "HC441a": {
        "C2H6": [3.1, 0.3, -0.3],
        "C3H8": [54.8, 2, -2],
        "HC600a": [6, 0.6, -0.6],
        "HC600": [36.1, 2, -2],
    },
    "HFC442a": {
        "HFC32": [31, 1, -1],
        "HFC125": [31, 1, -1],
        "HFC134a": [30, 1, -1],
        "HFC152a": [3, 0.5, -0.5],
        "HFC227ea": [5, 1, -1],
    },
    "HO443a": {"HO1270": [55, 2, -2], "C3H8": [40, 2, -2], "HC600a": [5, 1.2, -1.2]},
    "HFO444a": {"HFC32": [12, 1, -1], "HFC152a": [5, 1, -1], "HFO1234ze": [83, 2, -2]},
    "HFO444b": {
        "HFC32": [41.5, 1, -1],
        "HFC152a": [10, 1, -1],
        "HFO1234ze": [48.5, 1, -1],
    },
    "HFO445a": {"CO2": [6, 1, -1], "HFC134a": [9, 1, -1], "HFO1234ze": [85, 2, -2]},
    "HFO446a": {
        "HFC32": [68, 0.5, -1],
        "HFO1234ze": [29, 2, -0.6],
        "HC600": [3, 0.1, -1.0],
    },
    "HFO447a": {
        "HFC32": [68, 1.5, -0.5],
        "HFC125": [3.5, 1.5, -0.5],
        "HFO1234ze": [28.5, 1, -1],
    },
    "HFO447b": {"HFC32": [68, 1, -2], "HFC125": [8, 2, -1], "HFO1234ze": [24, 1, -2]},
    "HFO448a": {
        "HFC32": [26, 0.5, -2],
        "HFC125": [26, 2, -0.5],
        "HFO1234yf": [20, 0.5, -2],
        "HFC134a": [21, 2, -1],
        "HFO1234ze": [7, 0.5, -2],
    },
    "HFO449a": {
        "HFC32": [24.3, 0.2, -1],
        "HFC125": [24.7, 1, -0.2],
        "HFO1234yf": [25.3, 0.2, -1],
        "HFC134a": [25.7, 1, -0.2],
    },
    "HFO449b": {
        "HFC32": [25.2, 0.3, -1.5],
        "HFC125": [24.3, 1.5, -0.3],
        "HFO1234yf": [23.2, 0.3, -1.5],
        "HFC134a": [27.3, 1.5, -0.3],
    },
    "HFO449c": {
        "HFC32": [20, 0.5, -1.5],
        "HFC125": [20, 1.5, -0.5],
        "HFO1234yf": [31, 0.5, -1.5],
        "HFC134a": [29, 1.5, -0.5],
    },
    "HFO450a": {"HFC134a": [42, 2, -2], "HFO1234ze": [58, 2, -2]},
    "HFO451a": {"HFO1234yf": [89.8, 0.2, -0.2], "HFC134a": [10.2, 0.2, -0.2]},
    "HFO451b": {"HFO1234yf": [88.8, 0.2, -0.2], "HFC134a": [11.2, 0.2, -0.2]},
    "HFO452a": {
        "HFC32": [11, 1.7, -1.7],
        "HFC125": [59, 1.8, -1.8],
        "HFO1234yf": [30, 0.1, -1],
    },
    "HFO452b": {
        "HFC32": [67, 2, -2],
        "HFC125": [7, 1.5, -1.5],
        "HFO1234yf": [26, 2, -2],
    },
    "HFO452c": {
        "HFC32": [12.5, 10.5, -1.5],
        "HFC125": [61, 1, -1],
        "HFO1234yf": [26.5, 0.5, -1.5],
    },
    "HFC453a": {
        "HFC32": [20, 1, -1],
        "HFC125": [20, 1, -1],
        "HFC134a": [53.8, 1, -1],
        "HFC227ea": [5, 0.5, -0.5],
        "HC600": [0.6, 0.1, -0.2],
        "HC601a": [0.6, 0.1, -0.2],
    },
    "HFO454a": {"HFC32": [35, 2, -2], "HFO1234yf": [65, 2, -2]},
    "HFO454b": {"HFC32": [68.9, 1, -1], "HFO1234yf": [31.1, 1, -1]},
    "HFO454c": {"HFC32": [21.5, 2, -2], "HFO1234yf": [78.5, 2, -2]},
    "HFO455a": {"CO2": [3, 2, -1], "HFC32": [21.5, 1, -2], "HFO1234yf": [75.5, 2, -2]},
    "HFO456a": {"HFC32": [6, 1, -1], "HFC134a": [45, 1, -1], "HFO1234ze": [49, 1, -1]},
    "HFO457a": {
        "HFC32": [18, 0.5, -1.5],
        "HFO1234yf": [70, 0.5, -1.5],
        "HFC152a": [12, 0.1, -1.9],
    },
    "HFC458a": {
        "HFC32": [20.5, 0.5, -0.5],
        "HFC125": [4, 0.5, -0.5],
        "HFC134a": [61.4, 0.5, -0.5],
        "HFC227ea": [13.5, 0.5, -0.5],
        "HFC236fa": [0.6, 0.1, -0.1],
    },
    "HFO459a": {
        "HFC32": [68, 0.5, -1.5],
        "HFO1234yf": [26, 2, -2],
        "HFO1234ze": [6, 1.5, -0.5],
    },
    "HFO459b": {
        "HFC32": [21, 0.5, -1.0],
        "HFO1234yf": [69, 2, -2],
        "HFO1234ze": [10, 1, -1],
    },
    "HFO460a": {
        "HFC32": [12, 1, -1],
        "HFC125": [52, 1, -1],
        "HFC134a": [14, 1, -1],
        "HFO1234ze": [22, 1, -1],
    },
    "HFO460b": {
        "HFC32": [28, 1, -1],
        "HFC125": [25, 1, -1],
        "HFC134a": [20, 1, -1],
        "HFO1234ze": [27, 1, -1],
    },
    "HFO460c": {
        "HFC32": [2.5, 0.5, -0.5],
        "HFC125": [2.5, 0.5, -0.5],
        "HFC134a": [46, 1, -1],
        "HFO1234ze": [49, 1, -1],
    },
    "HFC461a": {
        "HFC125": [55, 1, -1],
        "HFC143a": [5, 0.5, -0.5],
        "HFC134a": [32, 1, -1],
        "HFC227ea": [5, 0.5, -0.5],
        "HC600a": [3, 0.1, -0.4],
    },
    "HFC462a": {
        "HFC32": [9, 1.5, -1],
        "HFC125": [42, 2, -2],
        "HFC143a": [2, 1, -1],
        "HFC134a": [44, 2, -2],
        "HC600": [3, 1, -1],
    },
    "HFO463a": {
        "CO2": [6, 2, -1],
        "HFC32": [36, 2, -2],
        "HFC125": [30, 2, -2],
        "HFO1234yf": [14, 2, -2],
        "HFC134a": [14, 2, -2],
    },
    "HFO464a": {
        "HFC32": [27, 1, -1],
        "HFC125": [27, 1, -1],
        "HFO1234ze": [40, 1, -1],
        "HFC227ea": [6, 0.5, -0.5],
    },
    "HFO465a": {
        "HFC32": [21, 0.5, -1.5],
        "C3H8": [7.9, 0.1, -0.9],
        "HFO1234yf": [71.1, 1, -1],
    },
    "HCFC500": {"CFC12": [73.8, _nan, _nan], "HFC152": [26.2, _nan, _nan]},
    "HCFC501": {"HCFC22": [75, _nan, _nan], "CFC12": [25, _nan, _nan]},
    "HCFC502": {"HCFC22": [48.8, _nan, _nan], "CFC115": [51.2, _nan, _nan]},
    "HCFC503": {"HFC23": [40.1, _nan, _nan], "CFC13": [59.9, _nan, _nan]},
    "HCFC504": {"HFC32": [48.2, _nan, _nan], "CFC115": [51.8, _nan, _nan]},
    "HCFC505": {"CFC12": [78, _nan, _nan], "HCFC31": [22, _nan, _nan]},
    "HCFC506": {"HCFC31": [55.1, _nan, _nan], "CFC114": [44.9, _nan, _nan]},
    "HFC507a": {"HFC125": [50, _nan, _nan], "HFC143a": [50, _nan, _nan]},
    "HFC508a": {"HFC23": [39, _nan, _nan], "C2F6": [61, _nan, _nan]},
    "HFC508b": {"HFC23": [46, _nan, _nan], "C2F6": [54, _nan, _nan]},
    "HCFC509a": {"HCFC22": [44, _nan, _nan], "C3F8": [56, _nan, _nan]},
    "HC510a": {"HCE170": [88, 0.5, -0.5], "HC600a": [12, 0.5, -0.5]},
    "HC511a": {"C3H8": [95, 1, -1], "HCE170": [5, 1, -1]},
    "HFC512a": {"HFC134a": [5, 1, -1], "HFC152a": [95, 1, -1]},
    "HFO513a": {"HFO1234yf": [56, 1, -1], "HFC134a": [44, 1, -1]},
    "HFO513b": {"HFO1234yf": [58.5, 0.5, -0.5], "HFC134a": [41.5, 0.5, -0.5]},
    "HCO514a": {"HFC1336mzz": [74.7, 1.5, -0.5], "HCO1130": [25.3, 0.5, -1.5]},
    "HFO515a": {"HFO1234ze": [88, 1, -2], "HFC227ea": [12, 2, -1]},
    "HFO516a": {
        "HFO1234yf": [77.5, 1.4, -1.4],
        "HFC134a": [8.5, 0.5, -1.5],
        "HFC152a": [14, 0.1, -1.9],
    },
}
"""
dict: Gas mixtures supported by OpenSCM Units

Last update: 2020-12-16

Each key is the mixture's name. Each value is itself a dictionary where each
key is the name of a component of the mixture and the value is a list in which
the first element is the standard composition, the second element is the positive
composition tolerance and the third element is the negative composition tolerance.
All values are given in mass percentage.

Sources:

- ANSI/ASHRAE Standard 34-2019, p. 9ff, ISSN 1041-2336, https://www.techstreet.com/ashrae/standards/ashrae-15-2019-packaged-w-34-2019?product_id=2046531

- https://en.wikipedia.org/wiki/List_of_refrigerants (for common names)
"""
