import mdpeditor.parameterhandler as parameterhandler


def help_string():
    return """
Use like\n
    [bold]compile density_guided.vanilla pixel-size-in-nm=0.98 some.mdp[/]

Run [bold]explain[/] to learn more about available options"""


def run_compile(compile_command, merge_right, full_mdp):

    try:
        output_parameters = parameterhandler.compile_parameters(
            compile_command)
    except ValueError as e:
        raise SystemExit(e.__str__())
    except AttributeError as e:
        raise SystemExit()

    if (not merge_right and output_parameters.duplicate_keys):
        raise SystemExit(
            "\nAborting compilation due to duplicate parameter(s)\n\n\t" +
            "\n\t".join(list(output_parameters.duplicate_keys)) +
            "\n\nUse --merge-duplicates to override parameters\n")

    if not full_mdp:
        # discard all parameters that were not explicitely chosen
        output_parameters.keep_only_modified()

    return output_parameters.as_string()


def print_annotated_output(console, output_string, version, arguments, output):
    # keep track of the command used to generate
    # the output by prepending a commented line
    output_string = f"[blue]; Created by mdpeditor version {version}\n" + \
                    "; " + ' '.join(arguments) + \
                    "\n[/]; To create self-documenting workflows, "\
                    "do not edit this file but rerun this tool with "\
                    "different settings\n" + output_string

    if output:
        console = Console(file=output)

    console.print(output_string)
