# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SurveyAssignment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SurveyAssignment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'survey_form': 'PublishedSurveyFormReference',
            'flow': 'DomainEntityRef',
            'invite_time_interval': 'str',
            'sending_user': 'str',
            'sending_domain': 'str'
        }

        self.attribute_map = {
            'survey_form': 'surveyForm',
            'flow': 'flow',
            'invite_time_interval': 'inviteTimeInterval',
            'sending_user': 'sendingUser',
            'sending_domain': 'sendingDomain'
        }

        self._survey_form = None
        self._flow = None
        self._invite_time_interval = None
        self._sending_user = None
        self._sending_domain = None

    @property
    def survey_form(self):
        """
        Gets the survey_form of this SurveyAssignment.
        The survey form used for this survey.

        :return: The survey_form of this SurveyAssignment.
        :rtype: PublishedSurveyFormReference
        """
        return self._survey_form

    @survey_form.setter
    def survey_form(self, survey_form):
        """
        Sets the survey_form of this SurveyAssignment.
        The survey form used for this survey.

        :param survey_form: The survey_form of this SurveyAssignment.
        :type: PublishedSurveyFormReference
        """
        
        self._survey_form = survey_form

    @property
    def flow(self):
        """
        Gets the flow of this SurveyAssignment.
        The URI reference to the flow associated with this survey.

        :return: The flow of this SurveyAssignment.
        :rtype: DomainEntityRef
        """
        return self._flow

    @flow.setter
    def flow(self, flow):
        """
        Sets the flow of this SurveyAssignment.
        The URI reference to the flow associated with this survey.

        :param flow: The flow of this SurveyAssignment.
        :type: DomainEntityRef
        """
        
        self._flow = flow

    @property
    def invite_time_interval(self):
        """
        Gets the invite_time_interval of this SurveyAssignment.
        An ISO 8601 repeated interval consisting of the number of repetitions, the start datetime, and the interval (e.g. R2/2018-03-01T13:00:00Z/P1M10DT2H30M). Total duration must not exceed 90 days.

        :return: The invite_time_interval of this SurveyAssignment.
        :rtype: str
        """
        return self._invite_time_interval

    @invite_time_interval.setter
    def invite_time_interval(self, invite_time_interval):
        """
        Sets the invite_time_interval of this SurveyAssignment.
        An ISO 8601 repeated interval consisting of the number of repetitions, the start datetime, and the interval (e.g. R2/2018-03-01T13:00:00Z/P1M10DT2H30M). Total duration must not exceed 90 days.

        :param invite_time_interval: The invite_time_interval of this SurveyAssignment.
        :type: str
        """
        
        self._invite_time_interval = invite_time_interval

    @property
    def sending_user(self):
        """
        Gets the sending_user of this SurveyAssignment.
        User together with sendingDomain used to send email, null to use no-reply

        :return: The sending_user of this SurveyAssignment.
        :rtype: str
        """
        return self._sending_user

    @sending_user.setter
    def sending_user(self, sending_user):
        """
        Sets the sending_user of this SurveyAssignment.
        User together with sendingDomain used to send email, null to use no-reply

        :param sending_user: The sending_user of this SurveyAssignment.
        :type: str
        """
        
        self._sending_user = sending_user

    @property
    def sending_domain(self):
        """
        Gets the sending_domain of this SurveyAssignment.
        Validated email domain, required

        :return: The sending_domain of this SurveyAssignment.
        :rtype: str
        """
        return self._sending_domain

    @sending_domain.setter
    def sending_domain(self, sending_domain):
        """
        Sets the sending_domain of this SurveyAssignment.
        Validated email domain, required

        :param sending_domain: The sending_domain of this SurveyAssignment.
        :type: str
        """
        
        self._sending_domain = sending_domain

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

