# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OutcomeProbabilityCondition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OutcomeProbabilityCondition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'outcome_id': 'str',
            'maximum_probability': 'float',
            'probability': 'float'
        }

        self.attribute_map = {
            'outcome_id': 'outcomeId',
            'maximum_probability': 'maximumProbability',
            'probability': 'probability'
        }

        self._outcome_id = None
        self._maximum_probability = None
        self._probability = None

    @property
    def outcome_id(self):
        """
        Gets the outcome_id of this OutcomeProbabilityCondition.
        The outcome ID.

        :return: The outcome_id of this OutcomeProbabilityCondition.
        :rtype: str
        """
        return self._outcome_id

    @outcome_id.setter
    def outcome_id(self, outcome_id):
        """
        Sets the outcome_id of this OutcomeProbabilityCondition.
        The outcome ID.

        :param outcome_id: The outcome_id of this OutcomeProbabilityCondition.
        :type: str
        """
        
        self._outcome_id = outcome_id

    @property
    def maximum_probability(self):
        """
        Gets the maximum_probability of this OutcomeProbabilityCondition.
        Probability value for the selected outcome at or above which the action map will trigger.

        :return: The maximum_probability of this OutcomeProbabilityCondition.
        :rtype: float
        """
        return self._maximum_probability

    @maximum_probability.setter
    def maximum_probability(self, maximum_probability):
        """
        Sets the maximum_probability of this OutcomeProbabilityCondition.
        Probability value for the selected outcome at or above which the action map will trigger.

        :param maximum_probability: The maximum_probability of this OutcomeProbabilityCondition.
        :type: float
        """
        
        self._maximum_probability = maximum_probability

    @property
    def probability(self):
        """
        Gets the probability of this OutcomeProbabilityCondition.
        Additional probability condition, where if set, the action map will trigger if the current outcome probability is lower or equal to the value.

        :return: The probability of this OutcomeProbabilityCondition.
        :rtype: float
        """
        return self._probability

    @probability.setter
    def probability(self, probability):
        """
        Sets the probability of this OutcomeProbabilityCondition.
        Additional probability condition, where if set, the action map will trigger if the current outcome probability is lower or equal to the value.

        :param probability: The probability of this OutcomeProbabilityCondition.
        :type: float
        """
        
        self._probability = probability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

