# coding: utf-8

"""
SpeechTextAnalyticsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class SpeechTextAnalyticsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_speechandtextanalytics_program(self, program_id, **kwargs):
        """
        Delete a Speech & Text Analytics program by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_program(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param bool force_delete: Indicates whether the program is forced to be deleted or not. Required when the program to delete is the default program.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'force_delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `delete_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}
        if 'force_delete' in params:
            query_params['forceDelete'] = params['force_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_sentimentfeedback(self, **kwargs):
        """
        Delete All Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_sentimentfeedback(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id(self, sentiment_feedback_id, **kwargs):
        """
        Delete a Speech & Text Analytics SentimentFeedback by Id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id(sentiment_feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sentiment_feedback_id: The Id of the SentimentFeedback (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sentiment_feedback_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sentiment_feedback_id' is set
        if ('sentiment_feedback_id' not in params) or (params['sentiment_feedback_id'] is None):
            raise ValueError("Missing the required parameter `sentiment_feedback_id` when calling `delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id`")


        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback/{sentimentFeedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'sentiment_feedback_id' in params:
            path_params['sentimentFeedbackId'] = params['sentiment_feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_topic(self, topic_id, **kwargs):
        """
        Delete a Speech & Text Analytics topic by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_topic(topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation(self, conversation_id, **kwargs):
        """
        Get Speech and Text Analytics for a specific conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation Id (required)
        :return: ConversationMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConversationMetrics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_communication_transcripturl(self, conversation_id, communication_id, **kwargs):
        """
        Get the pre-signed S3 URL for the transcript of a specific communication of a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_communication_transcripturl(conversation_id, communication_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str communication_id: Communication ID (required)
        :return: TranscriptUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'communication_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_communication_transcripturl" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturl`")
        # verify the required parameter 'communication_id' is set
        if ('communication_id' not in params) or (params['communication_id'] is None):
            raise ValueError("Missing the required parameter `communication_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturl`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/communications/{communicationId}/transcripturl'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'communication_id' in params:
            path_params['communicationId'] = params['communication_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptUrl',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_dialects(self, **kwargs):
        """
        Get list of supported Speech & Text Analytics dialects
        This api has been deprecated. Use api/v2/topics/dialects instead

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[object]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program(self, program_id, **kwargs):
        """
        Get a Speech & Text Analytics program by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program_mappings(self, program_id, **kwargs):
        """
        Get Speech & Text Analytics program mappings to queues and flows by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program_mappings(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: ProgramMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program_mappings`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/mappings'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramMappings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs(self, **kwargs):
        """
        Get the list of Speech & Text Analytics programs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: ProgramsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_general_job(self, job_id, **kwargs):
        """
        Get a Speech & Text Analytics general program job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_general_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish programs job (required)
        :return: GeneralProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_general_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_programs_general_job`")


        resource_path = '/api/v2/speechandtextanalytics/programs/general/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_mappings(self, **kwargs):
        """
        Get the list of Speech & Text Analytics programs mappings to queues and flows
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_mappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: ProgramsMappingsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_mappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/mappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramsMappingsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_publishjob(self, job_id, **kwargs):
        """
        Get a Speech & Text Analytics publish programs job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_publishjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish programs job (required)
        :return: ProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_publishjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_programs_publishjob`")


        resource_path = '/api/v2/speechandtextanalytics/programs/publishjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_unpublished(self, **kwargs):
        """
        Get the list of Speech & Text Analytics unpublished programs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_unpublished(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: UnpublishedProgramsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_unpublished" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/unpublished'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UnpublishedProgramsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_sentiment_dialects(self, **kwargs):
        """
        Get the list of Speech & Text Analytics sentiment supported dialects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_sentiment_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_sentiment_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentiment/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_sentimentfeedback(self, **kwargs):
        """
        Get the list of Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_sentimentfeedback(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The key for filter the listing by dialect, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :return: SentimentFeedbackEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SentimentFeedbackEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_settings(self, **kwargs):
        """
        Get Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topic(self, topic_id, **kwargs):
        """
        Get a Speech & Text Analytics topic by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topic(topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics(self, **kwargs):
        """
        Get the list of Speech & Text Analytics topics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :param str state: Topic state. Defaults to latest
        :param str name: Case insensitive partial name to filter by
        :param list[str] ids: Comma separated Topic IDs to filter by. Cannot be used with other filters. Maximum of 50 IDs allowed.
        :param str sort_by: Sort results by. Defaults to name
        :param str sort_order: Sort order. Defaults to asc
        :return: TopicsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size', 'state', 'name', 'ids', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_dialects(self, **kwargs):
        """
        Get list of supported Speech & Text Analytics topics dialects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_general(self, **kwargs):
        """
        Get the Speech & Text Analytics general topics for a given dialect
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_general(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The dialect of the general topics, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :return: GeneralTopicsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_general" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics/general'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralTopicsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_publishjob(self, job_id, **kwargs):
        """
        Get a Speech & Text Analytics publish topics job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_publishjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish topics job (required)
        :return: TopicJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_publishjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_topics_publishjob`")


        resource_path = '/api/v2/speechandtextanalytics/topics/publishjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_speechandtextanalytics_settings(self, body, **kwargs):
        """
        Patch Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_speechandtextanalytics_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpeechTextAnalyticsSettingsRequest body: Speech And Text Analytics Settings (required)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_speechandtextanalytics_settings`")


        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs(self, body, **kwargs):
        """
        Create new Speech & Text Analytics program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProgramRequest body: The program to create (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs`")


        resource_path = '/api/v2/speechandtextanalytics/programs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs_general_jobs(self, body, **kwargs):
        """
        Create new Speech & Text Analytics general program job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs_general_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GeneralProgramJobRequest body: The general programs job to create (required)
        :return: GeneralProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs_general_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs_general_jobs`")


        resource_path = '/api/v2/speechandtextanalytics/programs/general/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs_publishjobs(self, body, **kwargs):
        """
        Create new Speech & Text Analytics publish programs job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs_publishjobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProgramJobRequest body: The publish programs job to create (required)
        :return: ProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs_publishjobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs_publishjobs`")


        resource_path = '/api/v2/speechandtextanalytics/programs/publishjobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_sentimentfeedback(self, body, **kwargs):
        """
        Create a Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_sentimentfeedback(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SentimentFeedback body: The SentimentFeedback to create (required)
        :return: SentimentFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_sentimentfeedback`")


        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SentimentFeedback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_topics(self, body, **kwargs):
        """
        Create new Speech & Text Analytics topic
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_topics(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TopicRequest body: The topic to create (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_topics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_topics`")


        resource_path = '/api/v2/speechandtextanalytics/topics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_topics_publishjobs(self, body, **kwargs):
        """
        Create new Speech & Text Analytics publish topics job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_topics_publishjobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TopicJobRequest body: The publish topics job to create (required)
        :return: TopicJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_topics_publishjobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_topics_publishjobs`")


        resource_path = '/api/v2/speechandtextanalytics/topics/publishjobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_transcripts_search(self, body, **kwargs):
        """
        Search resources.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_transcripts_search(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TranscriptSearchRequest body: Search request options (required)
        :return: JsonSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_transcripts_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_transcripts_search`")


        resource_path = '/api/v2/speechandtextanalytics/transcripts/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JsonSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program(self, program_id, body, **kwargs):
        """
        Update existing Speech & Text Analytics program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param ProgramRequest body: The program to update (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program_mappings(self, program_id, body, **kwargs):
        """
        Set Speech & Text Analytics program mappings to queues and flows
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program_mappings(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param ProgramMappingsRequest body: The program to set mappings for (required)
        :return: ProgramMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program_mappings`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program_mappings`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/mappings'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramMappings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_settings(self, body, **kwargs):
        """
        Update Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpeechTextAnalyticsSettingsRequest body: Speech And Text Analytics Settings (required)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_settings`")


        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_topic(self, topic_id, body, **kwargs):
        """
        Update existing Speech & Text Analytics topic
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_topic(topic_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :param TopicRequest body: The topic to update (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `put_speechandtextanalytics_topic`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
