# coding: utf-8

"""
RecordingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RecordingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_conversation_recording_annotation(self, conversation_id, recording_id, annotation_id, **kwargs):
        """
        Delete annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_conversation_recording_annotation(conversation_id, recording_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_conversation_recording_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_conversation_recording_annotation`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `delete_conversation_recording_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `delete_conversation_recording_annotation`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orphanrecording(self, orphan_id, **kwargs):
        """
        Deletes a single orphan recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orphanrecording(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :return: OrphanRecording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orphanrecording" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `delete_orphanrecording`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_recording_crossplatform_mediaretentionpolicies(self, ids, **kwargs):
        """
        Delete media retention policies
        Bulk delete of media retention policies, this will only delete the polices that match the ids specified in the query param.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recording_crossplatform_mediaretentionpolicies(ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ids:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recording_crossplatform_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ids' is set
        if ('ids' not in params) or (params['ids'] is None):
            raise ValueError("Missing the required parameter `ids` when calling `delete_recording_crossplatform_mediaretentionpolicies`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_recording_crossplatform_mediaretentionpolicy(self, policy_id, **kwargs):
        """
        Delete a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recording_crossplatform_mediaretentionpolicy(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recording_crossplatform_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `delete_recording_crossplatform_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_recording_job(self, job_id, **kwargs):
        """
        Delete the recording bulk job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recording_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recording_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `delete_recording_job`")


        resource_path = '/api/v2/recording/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_recording_mediaretentionpolicies(self, ids, **kwargs):
        """
        Delete media retention policies
        Bulk delete of media retention policies, this will only delete the polices that match the ids specified in the query param.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recording_mediaretentionpolicies(ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ids:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recording_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ids' is set
        if ('ids' not in params) or (params['ids'] is None):
            raise ValueError("Missing the required parameter `ids` when calling `delete_recording_mediaretentionpolicies`")


        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_recording_mediaretentionpolicy(self, policy_id, **kwargs):
        """
        Delete a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_recording_mediaretentionpolicy(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recording_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `delete_recording_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recording(self, conversation_id, recording_id, **kwargs):
        """
        Gets a specific recording.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recording(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str format_id: The desired media format.
        :param str email_format_id: The desired media format when downloading an email recording.
        :param str chat_format_id: The desired media format when downloading a chat recording.
        :param str message_format_id: The desired media format when downloading a message recording.
        :param bool download: requesting a download format of the recording
        :param str file_name: the name of the downloaded fileName
        :param str locale: The locale for the requested file when downloading, as an ISO 639-1 code
        :return: Recording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'format_id', 'email_format_id', 'chat_format_id', 'message_format_id', 'download', 'file_name', 'locale']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recording" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recording`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_recording`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']
        if 'email_format_id' in params:
            query_params['emailFormatId'] = params['email_format_id']
        if 'chat_format_id' in params:
            query_params['chatFormatId'] = params['chat_format_id']
        if 'message_format_id' in params:
            query_params['messageFormatId'] = params['message_format_id']
        if 'download' in params:
            query_params['download'] = params['download']
        if 'file_name' in params:
            query_params['fileName'] = params['file_name']
        if 'locale' in params:
            query_params['locale'] = params['locale']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recording_annotation(self, conversation_id, recording_id, annotation_id, **kwargs):
        """
        Get annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recording_annotation(conversation_id, recording_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recording_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recording_annotation`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_recording_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_conversation_recording_annotation`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recording_annotations(self, conversation_id, recording_id, **kwargs):
        """
        Get annotations for recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recording_annotations(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :return: list[Annotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recording_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recording_annotations`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_recording_annotations`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Annotation]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recordingmetadata(self, conversation_id, **kwargs):
        """
        Get recording metadata for a conversation. Does not return playable media.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recordingmetadata(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :return: list[RecordingMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recordingmetadata" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recordingmetadata`")


        resource_path = '/api/v2/conversations/{conversationId}/recordingmetadata'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[RecordingMetadata]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recordingmetadata_recording_id(self, conversation_id, recording_id, **kwargs):
        """
        Get metadata for a specific recording. Does not return playable media.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recordingmetadata_recording_id(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :return: RecordingMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recordingmetadata_recording_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recordingmetadata_recording_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_recordingmetadata_recording_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordingmetadata/{recordingId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingMetadata',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_recordings(self, conversation_id, **kwargs):
        """
        Get all of a Conversation's Recordings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_recordings(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param int max_wait_ms: The maximum number of milliseconds to wait for the recording to be ready. Must be a positive value.
        :param str format_id: The desired media format
        :return: list[Recording]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'max_wait_ms', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_recordings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_recordings`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'max_wait_ms' in params:
            query_params['maxWaitMs'] = params['max_wait_ms']
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Recording]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orphanrecording(self, orphan_id, **kwargs):
        """
        Gets a single orphan recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orphanrecording(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :return: OrphanRecording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orphanrecording" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `get_orphanrecording`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orphanrecording_media(self, orphan_id, **kwargs):
        """
        Gets the media of a single orphan recording
        A 202 response means the orphaned media is currently transcoding and will be available shortly.A 200 response denotes the transcoded orphan media is available now and is contained in the response body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orphanrecording_media(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :param str format_id: The desired media format.
        :param str email_format_id: The desired media format when downloading an email recording.
        :param str chat_format_id: The desired media format when downloading a chat recording.
        :param str message_format_id: The desired media format when downloading a message recording.
        :param bool download: requesting a download format of the recording
        :param str file_name: the name of the downloaded fileName
        :param str locale: The locale for the requested file when downloading, as an ISO 639-1 code
        :return: Recording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id', 'format_id', 'email_format_id', 'chat_format_id', 'message_format_id', 'download', 'file_name', 'locale']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orphanrecording_media" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `get_orphanrecording_media`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}/media'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']
        if 'email_format_id' in params:
            query_params['emailFormatId'] = params['email_format_id']
        if 'chat_format_id' in params:
            query_params['chatFormatId'] = params['chat_format_id']
        if 'message_format_id' in params:
            query_params['messageFormatId'] = params['message_format_id']
        if 'download' in params:
            query_params['download'] = params['download']
        if 'file_name' in params:
            query_params['fileName'] = params['file_name']
        if 'locale' in params:
            query_params['locale'] = params['locale']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orphanrecordings(self, **kwargs):
        """
        Gets all orphan recordings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orphanrecordings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param bool has_conversation: Filter resulting orphans by whether the conversation is known. False returns all orphans for the organization.
        :param str media: Filter resulting orphans based on their media type
        :return: OrphanRecordingListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'has_conversation', 'media']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orphanrecordings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orphanrecordings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'has_conversation' in params:
            query_params['hasConversation'] = params['has_conversation']
        if 'media' in params:
            query_params['media'] = params['media']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecordingListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_batchrequest(self, job_id, **kwargs):
        """
        Get the status and results for a batch request job, only the user that submitted the job may retrieve results
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_batchrequest(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: BatchDownloadJobStatusResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_batchrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_recording_batchrequest`")


        resource_path = '/api/v2/recording/batchrequests/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BatchDownloadJobStatusResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_crossplatform_mediaretentionpolicies(self, **kwargs):
        """
        Gets media retention policy list with query options to filter on name and enabled.
        for a less verbose response, add summary=true to this endpoint

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_crossplatform_mediaretentionpolicies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str name: the policy name - used for filtering results in searches.
        :param bool enabled: checks to see if policy is enabled - use enabled = true or enabled = false
        :param bool summary: provides a less verbose response of policy lists.
        :param bool has_errors: provides a way to fetch all policies with errors or policies that do not have errors
        :return: PolicyEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'name', 'enabled', 'summary', 'has_errors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_crossplatform_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'enabled' in params:
            query_params['enabled'] = params['enabled']
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'has_errors' in params:
            query_params['hasErrors'] = params['has_errors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PolicyEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_crossplatform_mediaretentionpolicy(self, policy_id, **kwargs):
        """
        Get a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_crossplatform_mediaretentionpolicy(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: CrossPlatformPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_crossplatform_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `get_recording_crossplatform_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CrossPlatformPolicy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_job(self, job_id, **kwargs):
        """
        Get the status of the job associated with the job id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: RecordingJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_recording_job`")


        resource_path = '/api/v2/recording/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_job_failedrecordings(self, job_id, **kwargs):
        """
        Get IDs of recordings that the bulk job failed for
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_job_failedrecordings(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :param int page_size: Page size. Maximum is 100.
        :param int page_number: Page number
        :param bool include_total: If false, cursor will be used to locate the page instead of pageNumber.
        :param str cursor: Indicates where to resume query results (not required for first page)
        :return: FailedRecordingEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'page_size', 'page_number', 'include_total', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_job_failedrecordings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_recording_job_failedrecordings`")


        resource_path = '/api/v2/recording/jobs/{jobId}/failedrecordings'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'include_total' in params:
            query_params['includeTotal'] = params['include_total']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FailedRecordingEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_jobs(self, **kwargs):
        """
        Get the status of all jobs within the user's organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str state: Filter by state
        :param bool show_only_my_jobs: Show only my jobs
        :param str job_type: Job Type (Can be left empty for both)
        :param bool include_total: If false, cursor will be used to locate the page instead of pageNumber.
        :param str cursor: Indicates where to resume query results (not required for first page)
        :return: RecordingJobEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'state', 'show_only_my_jobs', 'job_type', 'include_total', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'show_only_my_jobs' in params:
            query_params['showOnlyMyJobs'] = params['show_only_my_jobs']
        if 'job_type' in params:
            query_params['jobType'] = params['job_type']
        if 'include_total' in params:
            query_params['includeTotal'] = params['include_total']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingJobEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_localkeys_setting(self, settings_id, **kwargs):
        """
        Get the local encryption settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_localkeys_setting(settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings Id (required)
        :return: LocalEncryptionConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_localkeys_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `get_recording_localkeys_setting`")


        resource_path = '/api/v2/recording/localkeys/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LocalEncryptionConfiguration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_localkeys_settings(self, **kwargs):
        """
        gets a list local key settings data
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_localkeys_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: LocalEncryptionConfigurationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_localkeys_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/localkeys/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LocalEncryptionConfigurationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_mediaretentionpolicies(self, **kwargs):
        """
        Gets media retention policy list with query options to filter on name and enabled.
        for a less verbose response, add summary=true to this endpoint

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_mediaretentionpolicies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str name: the policy name - used for filtering results in searches.
        :param bool enabled: checks to see if policy is enabled - use enabled = true or enabled = false
        :param bool summary: provides a less verbose response of policy lists.
        :param bool has_errors: provides a way to fetch all policies with errors or policies that do not have errors
        :return: PolicyEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'name', 'enabled', 'summary', 'has_errors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'enabled' in params:
            query_params['enabled'] = params['enabled']
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'has_errors' in params:
            query_params['hasErrors'] = params['has_errors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PolicyEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_mediaretentionpolicy(self, policy_id, **kwargs):
        """
        Get a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_mediaretentionpolicy(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `get_recording_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_recordingkeys(self, **kwargs):
        """
        Get encryption key list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_recordingkeys(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: EncryptionKeyEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_recordingkeys" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/recordingkeys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EncryptionKeyEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_recordingkeys_rotationschedule(self, **kwargs):
        """
        Get key rotation schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_recordingkeys_rotationschedule(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: KeyRotationSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_recordingkeys_rotationschedule" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/recordingkeys/rotationschedule'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeyRotationSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recording_settings(self, **kwargs):
        """
        Get the Recording Settings for the Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recording_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool create_default: If no settings are found, a new one is created with default values
        :return: RecordingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_default']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recording_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'create_default' in params:
            query_params['createDefault'] = params['create_default']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_recordings_screensessions(self, **kwargs):
        """
        Retrieves a paged listing of screen recording sessions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recordings_screensessions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: ScreenRecordingSessionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recordings_screensessions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recordings/screensessions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScreenRecordingSessionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_recording_crossplatform_mediaretentionpolicy(self, policy_id, body, **kwargs):
        """
        Patch a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_recording_crossplatform_mediaretentionpolicy(policy_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param CrossPlatformPolicyUpdate body: Policy (required)
        :return: CrossPlatformPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_recording_crossplatform_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `patch_recording_crossplatform_mediaretentionpolicy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_recording_crossplatform_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CrossPlatformPolicy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_recording_mediaretentionpolicy(self, policy_id, body, **kwargs):
        """
        Patch a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_recording_mediaretentionpolicy(policy_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param PolicyUpdate body: Policy (required)
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_recording_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `patch_recording_mediaretentionpolicy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_recording_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_recordings_screensession(self, recording_session_id, **kwargs):
        """
        Update a screen recording session
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_recordings_screensession(recording_session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str recording_session_id: Screen recording session ID (required)
        :param ScreenRecordingSessionRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recording_session_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_recordings_screensession" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'recording_session_id' is set
        if ('recording_session_id' not in params) or (params['recording_session_id'] is None):
            raise ValueError("Missing the required parameter `recording_session_id` when calling `patch_recordings_screensession`")


        resource_path = '/api/v2/recordings/screensessions/{recordingSessionId}'.replace('{format}', 'json')
        path_params = {}
        if 'recording_session_id' in params:
            path_params['recordingSessionId'] = params['recording_session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversation_recording_annotations(self, conversation_id, recording_id, body, **kwargs):
        """
        Create annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversation_recording_annotations(conversation_id, recording_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param Annotation body: annotation (required)
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversation_recording_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversation_recording_annotations`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `post_conversation_recording_annotations`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_conversation_recording_annotations`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_batchrequests(self, body, **kwargs):
        """
        Submit a batch download request for recordings. Recordings in response will be in their original format/codec - configured in the Trunk configuration.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_batchrequests(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BatchDownloadJobSubmission body: Job submission criteria (required)
        :return: BatchDownloadJobSubmissionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_batchrequests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_batchrequests`")


        resource_path = '/api/v2/recording/batchrequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BatchDownloadJobSubmissionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_crossplatform_mediaretentionpolicies(self, body, **kwargs):
        """
        Create media retention policy
        Policy does not work retroactively

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_crossplatform_mediaretentionpolicies(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CrossPlatformPolicyCreate body: Policy (required)
        :return: CrossPlatformPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_crossplatform_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_crossplatform_mediaretentionpolicies`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CrossPlatformPolicy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_jobs(self, body, **kwargs):
        """
        Create a recording bulk job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RecordingJobsQuery body: query (required)
        :return: RecordingJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_jobs`")


        resource_path = '/api/v2/recording/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_localkeys(self, body, **kwargs):
        """
        create a local recording key
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_localkeys(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LocalEncryptionKeyRequest body: Local Encryption body (required)
        :return: EncryptionKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_localkeys" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_localkeys`")


        resource_path = '/api/v2/recording/localkeys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EncryptionKey',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_localkeys_settings(self, body, **kwargs):
        """
        create settings for local key creation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_localkeys_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LocalEncryptionConfiguration body: Local Encryption Configuration (required)
        :return: LocalEncryptionConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_localkeys_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_localkeys_settings`")


        resource_path = '/api/v2/recording/localkeys/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LocalEncryptionConfiguration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_mediaretentionpolicies(self, body, **kwargs):
        """
        Create media retention policy
        Policy does not work retroactively

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_mediaretentionpolicies(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PolicyCreate body: Policy (required)
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recording_mediaretentionpolicies`")


        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recording_recordingkeys(self, **kwargs):
        """
        Create encryption key
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recording_recordingkeys(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EncryptionKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recording_recordingkeys" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/recordingkeys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EncryptionKey',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recordings_deletionprotection(self, body, **kwargs):
        """
        Get a list of conversations with protected recordings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recordings_deletionprotection(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConversationDeletionProtectionQuery body: conversationIds (required)
        :return: list[AddressableEntityRef]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recordings_deletionprotection" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recordings_deletionprotection`")


        resource_path = '/api/v2/recordings/deletionprotection'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[AddressableEntityRef]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recordings_screensessions_acknowledge(self, body, **kwargs):
        """
        Acknowledge a screen recording.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recordings_screensessions_acknowledge(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AcknowledgeScreenRecordingRequest body: AcknowledgeScreenRecordingRequest (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recordings_screensessions_acknowledge" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recordings_screensessions_acknowledge`")


        resource_path = '/api/v2/recordings/screensessions/acknowledge'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_recordings_screensessions_metadata(self, body, **kwargs):
        """
        Provide meta-data a screen recording.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_recordings_screensessions_metadata(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScreenRecordingMetaDataRequest body: ScreenRecordingMetaDataRequest (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_recordings_screensessions_metadata" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_recordings_screensessions_metadata`")


        resource_path = '/api/v2/recordings/screensessions/metadata'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_conversation_recording(self, conversation_id, recording_id, body, **kwargs):
        """
        Updates the retention records on a recording.
        Currently supports updating and removing both archive and delete dates for eligible recordings. A request to change the archival date of an archived recording will result in a restoration of the recording until the new date set. The recording:recording:view permission is required for the recording, as well as either the recording:recording:editRetention or recording:screenRecording:editRetention permissions depending on the type of recording.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_conversation_recording(conversation_id, recording_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param Recording body: recording (required)
        :return: Recording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_conversation_recording" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_conversation_recording`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `put_conversation_recording`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_conversation_recording`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_conversation_recording_annotation(self, conversation_id, recording_id, annotation_id, body, **kwargs):
        """
        Update annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_conversation_recording_annotation(conversation_id, recording_id, annotation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :param Annotation body: annotation (required)
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_conversation_recording_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_conversation_recording_annotation`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `put_conversation_recording_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `put_conversation_recording_annotation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_conversation_recording_annotation`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orphanrecording(self, orphan_id, **kwargs):
        """
        Updates an orphan recording to a regular recording with retention values
        If this operation is successful the orphan will no longer exist. It will be replaced by the resulting recording in the response. This replacement recording is accessible by the normal Recording api.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orphanrecording(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :param OrphanUpdateRequest body: 
        :return: Recording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orphanrecording" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `put_orphanrecording`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Recording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_crossplatform_mediaretentionpolicy(self, policy_id, body, **kwargs):
        """
        Update a media retention policy
        Policy does not work retroactively

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_crossplatform_mediaretentionpolicy(policy_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param CrossPlatformPolicy body: Policy (required)
        :return: CrossPlatformPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_crossplatform_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `put_recording_crossplatform_mediaretentionpolicy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_crossplatform_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/crossplatform/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CrossPlatformPolicy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_job(self, job_id, body, **kwargs):
        """
        Execute the recording bulk job.
        A job must be executed by the same user whom originally created the job.  In addition, the user must have permission to update the recording's retention.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_job(job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :param ExecuteRecordingJobsQuery body: query (required)
        :return: RecordingJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `put_recording_job`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_job`")


        resource_path = '/api/v2/recording/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_localkeys_setting(self, settings_id, body, **kwargs):
        """
        Update the local encryption settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_localkeys_setting(settings_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings Id (required)
        :param LocalEncryptionConfiguration body: Local Encryption metadata (required)
        :return: LocalEncryptionConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_localkeys_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `put_recording_localkeys_setting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_localkeys_setting`")


        resource_path = '/api/v2/recording/localkeys/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LocalEncryptionConfiguration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_mediaretentionpolicy(self, policy_id, body, **kwargs):
        """
        Update a media retention policy
        Policy does not work retroactively

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_mediaretentionpolicy(policy_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param Policy body: Policy (required)
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_mediaretentionpolicy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `put_recording_mediaretentionpolicy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_mediaretentionpolicy`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_recordingkeys_rotationschedule(self, body, **kwargs):
        """
        Update key rotation schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_recordingkeys_rotationschedule(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param KeyRotationSchedule body: KeyRotationSchedule (required)
        :return: KeyRotationSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_recordingkeys_rotationschedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_recordingkeys_rotationschedule`")


        resource_path = '/api/v2/recording/recordingkeys/rotationschedule'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeyRotationSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recording_settings(self, body, **kwargs):
        """
        Update the Recording Settings for the Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recording_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RecordingSettings body: Recording settings (required)
        :return: RecordingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recording_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_recording_settings`")


        resource_path = '/api/v2/recording/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_recordings_deletionprotection(self, **kwargs):
        """
        Apply or revoke recording protection for conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_recordings_deletionprotection(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool protect: Check for apply, uncheck for revoke (each action requires the respective permission)
        :param ConversationDeletionProtectionQuery body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['protect', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_recordings_deletionprotection" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recordings/deletionprotection'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'protect' in params:
            query_params['protect'] = params['protect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
