"""
Reference:
    https://github.com/knownsec/pocsuite3/blob/master/pocsuite3/lib/core/enums.py
"""


class POC_TYPE:
    UNKNOWN = 'Unknown'
    HTTP_PARAMETER_POLLUTION = 'HTTP Parameter Pollution'
    BACKDOOR = 'Backdoor'
    INSECURE_COOKIE_HANDLING = 'Insecure Cookie Handling'
    CSRF = 'CSRF'
    SHELLCODE = 'ShellCode'
    SQL_INJECTION = 'SQL Injection'
    ARBITRARY_FILE_DOWNLOAD = 'Arbitrary File Download'
    ARBITRARY_FILE_CREATION = 'Arbitrary File Creation'
    ARBITRARY_FILE_DELETION = 'Arbitrary File Deletion'
    ARBITRARY_FILE_READ = 'Arbitrary File Read'
    OTHER = 'Other'
    VARIABLE_COVERAGE = 'Variable Coverage'
    COMMAND_EXECUTION = 'Command Execution'
    INJECTING_MALWARE_CODES = 'Injecting Malware Codes'
    WEAK_PASSWORD = 'Weak Password'
    DENIAL_OF_SERVICE = 'Denial Of service'
    DATABASE_FOUND = 'Database Found'
    UPLOAD_FILES = 'Upload Files'
    REMOTE_FILE_INCLUSION = 'Remote File Inclusion'
    LOCAL_OVERFLOW = 'Local Overflow'
    PRIVILEGE_ESCALATION = 'Privilege Escalation'
    INFORMATION_DISCLOSURE = 'Information Disclosure'
    LOGIN_BYPASS = 'Login Bypass'
    PATH_TRAVERSAL = 'Path Traversal'
    RESOLVE_ERROR = 'Resolve Error'
    UNAUTHORIZED_ACCESS = 'Unauthorized Access'
    XSS = 'XSS'
    PATH_DISCLOSURE = 'Path Disclosure'
    CODE_EXECUTION = 'Code Execution'
    REMOTE_PASSWORD_CHANGE = 'Remote Password Change'
    REMOTE_OVERFLOW = 'Remote Overflow'
    DIRECTORY_LISTING = 'Directory Listing'
    NULL_BYTE_INJECTION = 'Null Byte Injection'
    MAN_IN_THE_MIDDLE = 'Man-in-the-middle'
    FORMAT_STRING = 'Format String'
    BUFFER_OVERFLOW = 'Buffer Overflow'
    HTTP_REQUEST_SPLITTING = 'HTTP Request Splitting'
    CRLF_INJECTION = 'CRLF Injection'
    XML_INJECTION = 'XML Injection'
    LOCAL_FILE_INCLUSION = 'Local File Inclusion'
    CREDENTIAL_PREDICTION = 'Credential Prediction'
    HTTP_RESPONSE_SPLITTING = 'HTTP Response Splitting'
    SSI_INJECTION = 'SSI Injection'
    OUT_OF_MEMORY = 'Out of Memory'
    INTEGER_OVERFLOWS = 'Integer Overflows'
    HTTP_RESPONSE_SMUGGLING = 'HTTP Response Smuggling'
    HTTP_REQUEST_SMUGGLING = 'HTTP Request Smuggling'
    CONTENT_SPOOFING = 'Content Spoofing'
    XQUERY_INJECTION = 'XQuery Injection'
    BUFFER_OVER_READ = 'Buffer Over-read'
    BRUTE_FORCE = 'Brute Force'
    LDAP_INJECTION = 'LDAP Injection'
    SECURITY_MODE_BYPASS = 'Security Mode Bypass'
    BACKUP_FILE = 'Backup File'
    XPATH_INJECTION = 'XPath Injection'
    URL_REDIRECTOR_ABUSE = 'URL Redirector Abuse'
    CODE_DISCLOSURE = 'Code Disclosure'
    USE_AFTER_FREE = 'Use After Free'
    DNS_HIJACKING = 'DNS Hijacking'
    IMPROPER_INPUT_VALIDATION = 'Improper Input Validation'
