"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const batch = require("../lib/");
exports.app = new cdk.App();
const stack = new cdk.Stack(exports.app, 'batch-stack');
const vpc = new ec2.Vpc(stack, 'vpc');
const launchTemplate = new ec2.CfnLaunchTemplate(stack, 'ec2-launch-template', {
    launchTemplateName: 'EC2LaunchTemplate',
    launchTemplateData: {
        blockDeviceMappings: [
            {
                deviceName: '/dev/xvdcz',
                ebs: {
                    encrypted: true,
                    volumeSize: 100,
                    volumeType: 'gp2',
                },
            },
        ],
    },
});
new batch.JobQueue(stack, 'batch-job-queue', {
    computeEnvironments: [
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-unmanaged-compute-env', {
                managed: false,
            }),
            order: 1,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-demand-compute-env-launch-template', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.ON_DEMAND,
                    vpc,
                    launchTemplate: {
                        launchTemplateName: launchTemplate.launchTemplateName,
                    },
                },
            }),
            order: 2,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-spot-compute-env', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.SPOT,
                    vpc,
                    bidPercentage: 80,
                },
            }),
            order: 3,
        },
    ],
});
const repo = new ecr.Repository(stack, 'batch-job-repo');
new batch.JobDefinition(stack, 'batch-job-def-from-ecr', {
    container: {
        image: new ecs.EcrImage(repo, 'latest'),
    },
});
new batch.JobDefinition(stack, 'batch-job-def-from-', {
    container: {
        image: ecs.ContainerImage.fromRegistry('docker/whalesay'),
    },
});
//# sourceMappingURL=data:application/json;base64,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