# varsom-avalanche-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v5.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import varsom_avalanche_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import varsom_avalanche_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import varsom_avalanche_client
from varsom_avalanche_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = varsom_avalanche_client.ArchiveApi(varsom_avalanche_client.ApiClient(configuration))
langkey = 56 # int | 
startdate = '2013-10-20T19:20:30+01:00' # datetime | 
enddate = '2013-10-20T19:20:30+01:00' # datetime | 
format = 'format_example' # str | 

try:
    api_response = api_instance.archive_all(langkey, startdate, enddate, format)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ArchiveApi->archive_all: %s\n" % e)

# create an instance of the API class
api_instance = varsom_avalanche_client.ArchiveApi(varsom_avalanche_client.ApiClient(configuration))
id = 56 # int | 
langkey = 56 # int | 
startdate = '2013-10-20T19:20:30+01:00' # datetime | 
enddate = '2013-10-20T19:20:30+01:00' # datetime | 
format = 'format_example' # str | 

try:
    api_response = api_instance.archive_region_id(id, langkey, startdate, enddate, format)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ArchiveApi->archive_region_id: %s\n" % e)

# create an instance of the API class
api_instance = varsom_avalanche_client.ArchiveApi(varsom_avalanche_client.ApiClient(configuration))
format = 'format_example' # str | 

try:
    api_response = api_instance.archive_regions(format)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ArchiveApi->archive_regions: %s\n" % e)

# create an instance of the API class
api_instance = varsom_avalanche_client.ArchiveApi(varsom_avalanche_client.ApiClient(configuration))
id = 56 # int | 
langkey = 56 # int | 
format = 'format_example' # str | 

try:
    api_response = api_instance.archive_warning_id(id, langkey, format)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ArchiveApi->archive_warning_id: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api01.nve.no/hydrology/forecast/avalanche/v5.0.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArchiveApi* | [**archive_all**](docs/ArchiveApi.md#archive_all) | **GET** /api/Archive/Warning/All/{langkey}/{startdate}/{enddate}/{format} | 
*ArchiveApi* | [**archive_region_id**](docs/ArchiveApi.md#archive_region_id) | **GET** /api/Archive/Warning/Region/{id}/{langkey}/{startdate}/{enddate}/{format} | 
*ArchiveApi* | [**archive_regions**](docs/ArchiveApi.md#archive_regions) | **GET** /api/Archive/Region/{format} | 
*ArchiveApi* | [**archive_warning_id**](docs/ArchiveApi.md#archive_warning_id) | **GET** /api/Archive/Warning/Id/{id}/{langkey}/{format} | 
*AvalancheWarningByCoordinatesApi* | [**avalanche_warning_by_coordinates_detail**](docs/AvalancheWarningByCoordinatesApi.md#avalanche_warning_by_coordinates_detail) | **GET** /api/AvalancheWarningByCoordinates/Detail/{x}/{y}/{langkey}/{startdate}/{enddate} | 
*AvalancheWarningByCoordinatesApi* | [**avalanche_warning_by_coordinates_obs**](docs/AvalancheWarningByCoordinatesApi.md#avalanche_warning_by_coordinates_obs) | **GET** /api/AvalancheWarningByCoordinates/Obs/{x}/{y}/{langkey}/{startdate}/{enddate} | 
*AvalancheWarningByCoordinatesApi* | [**avalanche_warning_by_coordinates_simple**](docs/AvalancheWarningByCoordinatesApi.md#avalanche_warning_by_coordinates_simple) | **GET** /api/AvalancheWarningByCoordinates/Simple/{x}/{y}/{langkey}/{startdate}/{enddate} | 
*AvalancheWarningByRegionApi* | [**avalanche_warning_by_region_detail**](docs/AvalancheWarningByRegionApi.md#avalanche_warning_by_region_detail) | **GET** /api/AvalancheWarningByRegion/Detail/{regionid}/{langkey}/{startdate}/{enddate} | 
*AvalancheWarningByRegionApi* | [**avalanche_warning_by_region_obs**](docs/AvalancheWarningByRegionApi.md#avalanche_warning_by_region_obs) | **GET** /api/AvalancheWarningByRegion/Obs/{regionid}/{langkey}/{startdate}/{enddate} | 
*AvalancheWarningByRegionApi* | [**avalanche_warning_by_region_simple**](docs/AvalancheWarningByRegionApi.md#avalanche_warning_by_region_simple) | **GET** /api/AvalancheWarningByRegion/Simple/{regionid}/{langkey}/{startdate}/{enddate} | 
*CapApi* | [**cap_feed**](docs/CapApi.md#cap_feed) | **GET** /api/Cap/Feed/{startdate}/{enddate} | 
*CapApi* | [**cap_id**](docs/CapApi.md#cap_id) | **GET** /api/Cap/Id/{id} | 
*RegionApi* | [**region_all**](docs/RegionApi.md#region_all) | **POST** /api/Region/{regionTypeId} | 
*RegionApi* | [**region_get**](docs/RegionApi.md#region_get) | **GET** /api/Region/{regionTypeId} | 
*RegionSummaryApi* | [**region_summary_detail**](docs/RegionSummaryApi.md#region_summary_detail) | **GET** /api/RegionSummary/Detail/{langkey}/{startdate}/{enddate} | 
*RegionSummaryApi* | [**region_summary_obs**](docs/RegionSummaryApi.md#region_summary_obs) | **GET** /api/RegionSummary/Obs/{langkey}/{startdate}/{enddate} | 
*RegionSummaryApi* | [**region_summary_simple**](docs/RegionSummaryApi.md#region_summary_simple) | **GET** /api/RegionSummary/Simple/{langkey}/{startdate}/{enddate} | 
*RegionSummaryApi* | [**region_summary_summary**](docs/RegionSummaryApi.md#region_summary_summary) | **GET** /api/RegionSummary/Summary/{langkey}/{startdate}/{enddate} | 
*WarningApi* | [**warning_all**](docs/WarningApi.md#warning_all) | **GET** /api/Warning/All/{langkey}/{startdate}/{enddate} | 
*WarningApi* | [**warning_id**](docs/WarningApi.md#warning_id) | **GET** /api/Warning/Id/{id}/{langkey} | 
*WarningApi* | [**warning_region**](docs/WarningApi.md#warning_region) | **GET** /api/Warning/Region/{id}/{langkey}/{startdate}/{enddate} | 

## Documentation For Models

 - [Advice](docs/Advice.md)
 - [Alert](docs/Alert.md)
 - [AlertInfo](docs/AlertInfo.md)
 - [AlertInfoArea](docs/AlertInfoArea.md)
 - [AlertInfoAreaGeocode](docs/AlertInfoAreaGeocode.md)
 - [AlertInfoEventCode](docs/AlertInfoEventCode.md)
 - [AlertInfoParameter](docs/AlertInfoParameter.md)
 - [AlertInfoResource](docs/AlertInfoResource.md)
 - [AvalancheProblem](docs/AvalancheProblem.md)
 - [AvalancheWarningDetail](docs/AvalancheWarningDetail.md)
 - [AvalancheWarningSimple](docs/AvalancheWarningSimple.md)
 - [CodePageDataItem](docs/CodePageDataItem.md)
 - [County](docs/County.md)
 - [DecoderFallback](docs/DecoderFallback.md)
 - [EncoderFallback](docs/EncoderFallback.md)
 - [Encoding](docs/Encoding.md)
 - [FormattedContentResultAlert](docs/FormattedContentResultAlert.md)
 - [FormattedContentResultListAlert](docs/FormattedContentResultListAlert.md)
 - [IRequiredMemberSelector](docs/IRequiredMemberSelector.md)
 - [MeasurementSubType](docs/MeasurementSubType.md)
 - [MeasurementType](docs/MeasurementType.md)
 - [MediaTypeFormatter](docs/MediaTypeFormatter.md)
 - [MediaTypeHeaderValue](docs/MediaTypeHeaderValue.md)
 - [MediaTypeMapping](docs/MediaTypeMapping.md)
 - [MountainWeather](docs/MountainWeather.md)
 - [Municipality](docs/Municipality.md)
 - [NameValueHeaderValue](docs/NameValueHeaderValue.md)
 - [ObsWarning](docs/ObsWarning.md)
 - [Region](docs/Region.md)
 - [RegionSummary](docs/RegionSummary.md)
 - [RegionSummaryObs](docs/RegionSummaryObs.md)
 - [Summary](docs/Summary.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


