# Zero Play [![Build Status Badge]][latest build] [![Code Coverage]][codecov] #
## Teach a computer to play any game. ##

[Build Status Badge]: https://travis-ci.org/donkirkby/zero-play.svg?branch=master
[latest build]: https://travis-ci.org/donkirkby/zero-play
[Code Coverage]: https://codecov.io/github/donkirkby/zero-play/coverage.svg?branch=master
[codecov]: https://codecov.io/github/donkirkby/zero-play?branch=master

The zero play library is based on the ideas in the [AlphaGo Zero paper] and the
example Python code in the [alpha-zero-general project]. The goal of this
project is to make a reusable Python library that other projects can build on
to make powerful computer opponents for many different board games. An example
project that uses this library is [Shibumi Games].

It includes a graphical display that you can use to play against the computer
opponent or another human.

![screenshot]

[AlphaGo Zero paper]: https://deepmind.com/blog/alphago-zero-learning-scratch/
[alpha-zero-general project]: https://github.com/suragnair/alpha-zero-general
[Shibumi Games]: https://donkirkby.github.io/shibumi-games/

## Installing Zero Play
Even though Zero Play has a graphical display, it is a regular Python package,
so you can install it with `pip install zero-play`. If you haven't installed
Python packages before, read Brett Cannon's [quick-and-dirty guide].

Then run it with the `zero_play_gui` command.

[quick-and-dirty guide]: https://snarky.ca/a-quick-and-dirty-guide-on-how-to-install-packages-for-python/

## More Information
If you'd like to help out with the project, or add your own games, see the
`CONTRIBUTING.md` file in the source code. For all the details, look through the
design [journal] for the project.

[journal]: docs/journal
[screenshot]: docs/images/screenshot.png
