# Generated by Django 3.0.5 on 2022-11-18 03:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Api',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('alias_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='Alias Name')),
                ('url', models.CharField(max_length=1024, unique=True, verbose_name='URL')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('username', models.CharField(blank=True, max_length=64, null=True, verbose_name='Operation User')),
            ],
            options={
                'verbose_name': 'Api',
                'verbose_name_plural': 'Api',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='ApiMethodMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drf_rbac.Api')),
            ],
            options={
                'verbose_name': 'api method',
                'verbose_name_plural': 'api method',
            },
        ),
        migrations.CreateModel(
            name='HttpMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
            ],
            options={
                'verbose_name': 'Http Methods',
                'verbose_name_plural': 'Http Methods',
            },
        ),
        migrations.CreateModel(
            name='Permission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Permission Name')),
                ('alias_name', models.CharField(blank=True, max_length=128, null=True, verbose_name='Alias Name')),
                ('type', models.CharField(choices=[('common', 'Page and Api'), ('api', 'Api'), ('page', 'Page')], db_index=True, default='common', max_length=64, verbose_name='Permission Type')),
                ('status', models.BooleanField(default=True, verbose_name='effective')),
                ('username', models.CharField(blank=True, max_length=128, null=True, verbose_name='Operation User')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('api', models.ManyToManyField(blank=True, to='drf_rbac.ApiMethodMembership', verbose_name='Related Api-Method')),
            ],
            options={
                'verbose_name': 'Role Permission',
                'verbose_name_plural': 'Role Permission',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Role',
                'verbose_name_plural': 'Role',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='UserToPermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('permission', models.ManyToManyField(to='drf_rbac.Permission')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='user_permission', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Permission',
                'verbose_name_plural': 'User Permission',
                'ordering': ('-created',),
            },
        ),
        migrations.AddField(
            model_name='permission',
            name='role',
            field=models.ManyToManyField(related_name='role_permission', to='drf_rbac.Role'),
        ),
        migrations.AddField(
            model_name='apimethodmembership',
            name='method',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drf_rbac.HttpMethod'),
        ),
        migrations.AddField(
            model_name='api',
            name='method',
            field=models.ManyToManyField(through='drf_rbac.ApiMethodMembership', to='drf_rbac.HttpMethod'),
        ),
        migrations.AlterUniqueTogether(
            name='permission',
            unique_together={('name', 'type')},
        ),
        migrations.AlterUniqueTogether(
            name='apimethodmembership',
            unique_together={('api', 'method')},
        ),
    ]
