"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabContainerRunner = exports.InstanceInterruptionBehavior = exports.BlockDuration = void 0;
const path = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @experimental
 */
var BlockDuration;
(function (BlockDuration) {
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    BlockDuration[BlockDuration["SEVEN_HOURS"] = 420] = "SEVEN_HOURS";
    BlockDuration[BlockDuration["EIGHT_HOURS"] = 480] = "EIGHT_HOURS";
    BlockDuration[BlockDuration["NINE_HOURS"] = 540] = "NINE_HOURS";
    BlockDuration[BlockDuration["TEN_HOURS"] = 600] = "TEN_HOURS";
    BlockDuration[BlockDuration["ELEVEN_HOURS"] = 660] = "ELEVEN_HOURS";
    BlockDuration[BlockDuration["TWELVE_HOURS"] = 720] = "TWELVE_HOURS";
    BlockDuration[BlockDuration["THIRTEEN_HOURS"] = 780] = "THIRTEEN_HOURS";
    BlockDuration[BlockDuration["FOURTEEN_HOURS"] = 840] = "FOURTEEN_HOURS";
    BlockDuration[BlockDuration["FIFTEEN_HOURS"] = 900] = "FIFTEEN_HOURS";
    BlockDuration[BlockDuration["SIXTEEN_HOURS"] = 960] = "SIXTEEN_HOURS";
    BlockDuration[BlockDuration["SEVENTEEN_HOURS"] = 1020] = "SEVENTEEN_HOURS";
    BlockDuration[BlockDuration["EIGHTTEEN_HOURS"] = 1080] = "EIGHTTEEN_HOURS";
    BlockDuration[BlockDuration["NINETEEN_HOURS"] = 1140] = "NINETEEN_HOURS";
    BlockDuration[BlockDuration["TWENTY_HOURS"] = 1200] = "TWENTY_HOURS";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
/**
 * @experimental
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * @experimental
 */
class GitlabContainerRunner extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        const spotFleetId = id;
        const token = props.gitlabtoken;
        const tags = (_a = props.tags) !== null && _a !== void 0 ? _a : ['gitlab', 'awscdk', 'runner'];
        const gitlaburl = (_b = props.gitlaburl) !== null && _b !== void 0 ? _b : 'https://gitlab.com/';
        const ec2type = (_c = props.ec2type) !== null && _c !== void 0 ? _c : 't3.micro';
        const runnerBucket = new aws_s3_1.Bucket(this, 'runnerBucket', {
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
        const shell = aws_ec2_1.UserData.forLinux();
        shell.addCommands('yum update -y ', 'sleep 15 && yum install docker git -y && systemctl start docker && usermod -aG docker ec2-user && chmod 777 /var/run/docker.sock', 'systemctl restart docker && systemctl enable docker', 'docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url ' +
            gitlaburl +
            ' --registration-token ' +
            token +
            ' --docker-pull-policy if-not-present ' + this.dockerVolumesList(props === null || props === void 0 ? void 0 : props.dockerVolumes) + ' --executor docker --docker-image "alpine:latest" --description "Docker Runner" --tag-list "' +
            this.synthesizeTags(tags) +
            '" --docker-privileged', 'sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine', 'usermod -aG docker ssm-user', `TOKEN=$(cat /home/ec2-user/.gitlab-runner/config.toml | grep token | cut -d '"' -f 2) && echo '{"token": "TOKEN"}' > /tmp/runnertoken.txt && sed -i s/TOKEN/$TOKEN/g /tmp/runnertoken.txt && aws s3 cp /tmp/runnertoken.txt s3://${runnerBucket.bucketName}/`);
        this.runnerRole = (_d = props.ec2iamrole) !== null && _d !== void 0 ? _d : new aws_iam_1.Role(this, 'runner-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        this.validUntil = props.validUntil;
        const instanceProfile = new aws_iam_1.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [this.runnerRole.roleName],
        });
        runnerBucket.grantWrite(this.runnerRole);
        this.vpc = (_e = props.selfvpc) !== null && _e !== void 0 ? _e : new aws_ec2_1.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [
                {
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
            ],
            natGateways: 0,
        });
        this.defaultRunnerSG = new aws_ec2_1.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        this.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(22));
        const spotOrOnDemand = (_f = props.spotFleet) !== null && _f !== void 0 ? _f : false;
        if (spotOrOnDemand) {
            //throw new Error('yes new spotfleet');
            const imageId = aws_ec2_1.MachineImage.latestAmazonLinux({
                generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).getImage(this).imageId;
            const lt = new aws_ec2_1.CfnLaunchTemplate(this, 'LaunchTemplate', {
                launchTemplateData: {
                    imageId,
                    instanceType: ec2type,
                    blockDeviceMappings: [
                        {
                            deviceName: '/dev/xvda',
                            ebs: {
                                volumeSize: (_g = props.ebsSize) !== null && _g !== void 0 ? _g : 60,
                            },
                        },
                    ],
                    userData: core_1.Fn.base64(shell.render()),
                    keyName: props.keyName,
                    tagSpecifications: [
                        {
                            resourceType: 'instance',
                            tags: [
                                {
                                    key: 'Name',
                                    value: `${core_1.Stack.of(this).stackName}/spotFleetGitlabRunner/${spotFleetId}`,
                                },
                            ],
                        },
                    ],
                    instanceMarketOptions: {
                        marketType: 'spot',
                        spotOptions: {
                            blockDurationMinutes: (_h = props.blockDuration) !== null && _h !== void 0 ? _h : BlockDuration.ONE_HOUR,
                            instanceInterruptionBehavior: (_j = props.instanceInterruptionBehavior) !== null && _j !== void 0 ? _j : InstanceInterruptionBehavior.TERMINATE,
                        },
                    },
                    securityGroupIds: this.defaultRunnerSG.connections.securityGroups.map((m) => m.securityGroupId),
                    iamInstanceProfile: {
                        arn: instanceProfile.attrArn,
                    },
                },
            });
            const spotFleetRole = new aws_iam_1.Role(this, 'FleetRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('spotfleet.amazonaws.com'),
                managedPolicies: [
                    aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
                ],
            });
            const vpcSubnetSelection = (_k = props.vpcSubnet) !== null && _k !== void 0 ? _k : {
                subnetType: aws_ec2_1.SubnetType.PUBLIC,
            };
            const subnetConfig = this.vpc
                .selectSubnets(vpcSubnetSelection)
                .subnets.map((s) => ({
                subnetId: s.subnetId,
            }));
            const cfnSpotFleet = new aws_ec2_1.CfnSpotFleet(this, id, {
                spotFleetRequestConfigData: {
                    launchTemplateConfigs: [
                        {
                            launchTemplateSpecification: {
                                launchTemplateId: lt.ref,
                                version: lt.attrLatestVersionNumber,
                            },
                            overrides: subnetConfig,
                        },
                    ],
                    iamFleetRole: spotFleetRole.roleArn,
                    targetCapacity: 1,
                    validUntil: core_1.Lazy.stringValue({ produce: () => this.validUntil }),
                    terminateInstancesWithExpiration: true,
                },
            });
            const onEvent = new lambda.Function(this, 'OnEvent', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../getinstanceId')),
                handler: 'index.on_event',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
            });
            const isComplete = new lambda.Function(this, 'IsComplete', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../getinstanceId')),
                handler: 'index.is_complete',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
                role: onEvent.role,
            });
            const myProvider = new cr.Provider(this, 'MyProvider', {
                onEventHandler: onEvent,
                isCompleteHandler: isComplete,
                logRetention: logs.RetentionDays.ONE_DAY,
            });
            onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
                actions: ['ec2:DescribeSpotFleetInstances'],
                resources: ['*'],
            }));
            const fleetInstances = new core_1.CustomResource(this, 'GetInstanceId', {
                serviceToken: myProvider.serviceToken,
                properties: {
                    SpotFleetRequestId: cfnSpotFleet.ref,
                },
            });
            fleetInstances.node.addDependency(cfnSpotFleet);
            this.spotFleetInstanceId = core_1.Token.asString(fleetInstances.getAtt('InstanceId'));
            this.spotFleetRequestId = core_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
            new core_1.CfnOutput(this, 'InstanceId', { value: this.spotFleetInstanceId });
            new core_1.CfnOutput(this, 'SpotFleetId', { value: cfnSpotFleet.ref });
        }
        else {
            this.runnerEc2 = new aws_ec2_1.Instance(this, 'GitlabRunner', {
                instanceType: new aws_ec2_1.InstanceType(ec2type),
                instanceName: 'Gitlab-Runner',
                vpc: this.vpc,
                vpcSubnets: (_l = props.vpcSubnet) !== null && _l !== void 0 ? _l : {
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
                machineImage: aws_ec2_1.MachineImage.latestAmazonLinux({
                    generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
                }),
                role: this.runnerRole,
                userData: shell,
                securityGroup: this.defaultRunnerSG,
                blockDevices: [
                    {
                        deviceName: '/dev/xvda',
                        volume: aws_ec2_1.BlockDeviceVolume.ebs((_m = props.ebsSize) !== null && _m !== void 0 ? _m : 60),
                    },
                ],
            });
            new core_1.CfnOutput(this, 'Runner-Instance-ID', {
                value: this.runnerEc2.instanceId,
            });
        }
        const unregisterRunnerOnEvent = new lambda.Function(this, 'unregisterRunnerOnEvent', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../getinstanceId')),
            handler: 'unregister_runner.on_event',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: core_1.Duration.seconds(60),
        });
        const unregisterRunnerProvider = new cr.Provider(this, 'unregisterRunnerProvider', {
            onEventHandler: unregisterRunnerOnEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const unregisterRunnerCR = new core_1.CustomResource(this, 'unregisterRunnerCR', {
            resourceType: 'Custom::unregisterRunnerProvider',
            serviceToken: unregisterRunnerProvider.serviceToken,
            properties: {
                BucketName: runnerBucket.bucketName,
                GitlabUrl: gitlaburl,
            },
        });
        runnerBucket.grantReadWrite(unregisterRunnerOnEvent);
        unregisterRunnerCR.node.addDependency(runnerBucket);
        this.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new core_1.CfnOutput(this, 'Runner-Role-Arn', {
            value: this.runnerRole.roleArn,
        });
    }
    /**
     * @default - !!! only support spotfleet runner !!! .
     * @experimental
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
    synthesizeTags(tags) {
        return tags.join(',');
    }
    dockerVolumesList(dockerVolume) {
        let tempString = '--docker-volumes "/var/run/docker.sock:/var/run/docker.sock"';
        if (dockerVolume) {
            let tempList = [];
            dockerVolume.forEach(e => {
                tempList.push(`"${e.hostPath}:${e.containerPath}"`);
            });
            tempList.forEach(e => {
                tempString = `${tempString} --docker-volumes ${e}`;
            });
        }
        return tempString;
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0bGFiLXJ1bm5lci1pbnNhdG5jZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRsYWItcnVubmVyLWluc2F0bmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZCQUE2QjtBQUM3Qiw4Q0FpQjBCO0FBQzFCLDhDQU8wQjtBQUMxQiw4Q0FBOEM7QUFDOUMsMENBQTBDO0FBQzFDLDRDQUF5QztBQUN6Qyx3Q0FVdUI7QUFDdkIsZ0RBQWdEOzs7O0FBcU9oRCxJQUFZLGFBcUJYO0FBckJELFdBQVksYUFBYTtJQUN2QiwwREFBYSxDQUFBO0lBQ2IsNkRBQWUsQ0FBQTtJQUNmLGlFQUFpQixDQUFBO0lBQ2pCLCtEQUFnQixDQUFBO0lBQ2hCLCtEQUFnQixDQUFBO0lBQ2hCLDZEQUFlLENBQUE7SUFDZixpRUFBaUIsQ0FBQTtJQUNqQixpRUFBaUIsQ0FBQTtJQUNqQiwrREFBZ0IsQ0FBQTtJQUNoQiw2REFBZSxDQUFBO0lBQ2YsbUVBQWtCLENBQUE7SUFDbEIsbUVBQWtCLENBQUE7SUFDbEIsdUVBQW9CLENBQUE7SUFDcEIsdUVBQW9CLENBQUE7SUFDcEIscUVBQW1CLENBQUE7SUFDbkIscUVBQW1CLENBQUE7SUFDbkIsMEVBQXNCLENBQUE7SUFDdEIsMEVBQXNCLENBQUE7SUFDdEIsd0VBQXFCLENBQUE7SUFDckIsb0VBQW1CLENBQUE7QUFDckIsQ0FBQyxFQXJCVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQXFCeEI7Ozs7QUFFRCxJQUFZLDRCQUlYO0FBSkQsV0FBWSw0QkFBNEI7SUFDdEMsdURBQXVCLENBQUE7SUFDdkIsNkNBQWEsQ0FBQTtJQUNiLHVEQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFKVyw0QkFBNEIsR0FBNUIsb0NBQTRCLEtBQTVCLG9DQUE0QixRQUl2Qzs7OztBQUVELE1BQWEscUJBQXNCLFNBQVEsZ0JBQVM7Ozs7SUFvQ2xELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBaUM7O1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxXQUFXLEdBQUcsRUFBRSxDQUFDO1FBQ3ZCLE1BQU0sS0FBSyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDaEMsTUFBTSxJQUFJLFNBQUcsS0FBSyxDQUFDLElBQUksbUNBQUksQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQzFELE1BQU0sU0FBUyxTQUFHLEtBQUssQ0FBQyxTQUFTLG1DQUFJLHFCQUFxQixDQUFDO1FBQzNELE1BQU0sT0FBTyxTQUFHLEtBQUssQ0FBQyxPQUFPLG1DQUFJLFVBQVUsQ0FBQztRQUM1QyxNQUFNLFlBQVksR0FBRyxJQUFJLGVBQU0sQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3BELGFBQWEsRUFBRSxvQkFBYSxDQUFDLE9BQU87U0FDckMsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxLQUFLLEdBQUcsa0JBQVEsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNsQyxLQUFLLENBQUMsV0FBVyxDQUNmLGdCQUFnQixFQUNoQixrSUFBa0ksRUFDbEkscURBQXFELEVBQ3JELDRNQUE0TTtZQUMxTSxTQUFTO1lBQ1Qsd0JBQXdCO1lBQ3hCLEtBQUs7WUFDTCx1Q0FBdUMsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLGFBQWEsQ0FBQyxHQUFHLDhGQUE4RjtZQUN2TCxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQztZQUN6Qix1QkFBdUIsRUFFekIsNkxBQTZMLEVBQzdMLDZCQUE2QixFQUM3QixvT0FBb08sWUFBWSxDQUFDLFVBQVUsR0FBRyxDQUMvUCxDQUFDO1FBRUYsSUFBSSxDQUFDLFVBQVUsU0FDYixLQUFLLENBQUMsVUFBVSxtQ0FDaEIsSUFBSSxjQUFJLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUM1QixTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQztZQUNwRCxXQUFXLEVBQUUsNEJBQTRCO1NBQzFDLENBQUMsQ0FBQztRQUNMLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxNQUFNLGVBQWUsR0FBRyxJQUFJLDRCQUFrQixDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRTtZQUN0RSxLQUFLLEVBQUUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztTQUNsQyxDQUFDLENBQUM7UUFDSCxZQUFZLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUN6QyxJQUFJLENBQUMsR0FBRyxTQUNOLEtBQUssQ0FBQyxPQUFPLG1DQUNiLElBQUksYUFBRyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDbkIsSUFBSSxFQUFFLGFBQWE7WUFDbkIsTUFBTSxFQUFFLENBQUM7WUFDVCxtQkFBbUIsRUFBRTtnQkFDbkI7b0JBQ0UsUUFBUSxFQUFFLEVBQUU7b0JBQ1osSUFBSSxFQUFFLFdBQVc7b0JBQ2pCLFVBQVUsRUFBRSxvQkFBVSxDQUFDLE1BQU07aUJBQzlCO2FBQ0Y7WUFDRCxXQUFXLEVBQUUsQ0FBQztTQUNmLENBQUMsQ0FBQztRQUNMLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSx1QkFBYSxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7WUFDNUQsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1NBQ2QsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsZ0JBQWdCLENBQUMsY0FBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ2hFLE1BQU0sY0FBYyxTQUFHLEtBQUssQ0FBQyxTQUFTLG1DQUFJLEtBQUssQ0FBQztRQUNoRCxJQUFJLGNBQWMsRUFBRTtZQUNsQix1Q0FBdUM7WUFFdkMsTUFBTSxPQUFPLEdBQUcsc0JBQVksQ0FBQyxpQkFBaUIsQ0FBQztnQkFDN0MsVUFBVSxFQUFFLCtCQUFxQixDQUFDLGNBQWM7YUFDakQsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUM7WUFDMUIsTUFBTSxFQUFFLEdBQUcsSUFBSSwyQkFBaUIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7Z0JBQ3ZELGtCQUFrQixFQUFFO29CQUNsQixPQUFPO29CQUNQLFlBQVksRUFBRSxPQUFPO29CQUNyQixtQkFBbUIsRUFBRTt3QkFDbkI7NEJBQ0UsVUFBVSxFQUFFLFdBQVc7NEJBQ3ZCLEdBQUcsRUFBRTtnQ0FDSCxVQUFVLFFBQUUsS0FBSyxDQUFDLE9BQU8sbUNBQUksRUFBRTs2QkFDaEM7eUJBQ0Y7cUJBQ0Y7b0JBQ0QsUUFBUSxFQUFFLFNBQUUsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDO29CQUNuQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87b0JBQ3RCLGlCQUFpQixFQUFFO3dCQUNqQjs0QkFDRSxZQUFZLEVBQUUsVUFBVTs0QkFDeEIsSUFBSSxFQUFFO2dDQUNKO29DQUNFLEdBQUcsRUFBRSxNQUFNO29DQUNYLEtBQUssRUFBRSxHQUNMLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FDakIsMEJBQTBCLFdBQVcsRUFBRTtpQ0FDeEM7NkJBQ0Y7eUJBQ0Y7cUJBQ0Y7b0JBQ0QscUJBQXFCLEVBQUU7d0JBQ3JCLFVBQVUsRUFBRSxNQUFNO3dCQUNsQixXQUFXLEVBQUU7NEJBQ1gsb0JBQW9CLFFBQ2xCLEtBQUssQ0FBQyxhQUFhLG1DQUFJLGFBQWEsQ0FBQyxRQUFROzRCQUMvQyw0QkFBNEIsUUFDMUIsS0FBSyxDQUFDLDRCQUE0QixtQ0FDbEMsNEJBQTRCLENBQUMsU0FBUzt5QkFDekM7cUJBQ0Y7b0JBQ0QsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLEdBQUcsQ0FDbkUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQ3pCO29CQUNELGtCQUFrQixFQUFFO3dCQUNsQixHQUFHLEVBQUUsZUFBZSxDQUFDLE9BQU87cUJBQzdCO2lCQUNGO2FBQ0YsQ0FBQyxDQUFDO1lBRUgsTUFBTSxhQUFhLEdBQUcsSUFBSSxjQUFJLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRTtnQkFDaEQsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMseUJBQXlCLENBQUM7Z0JBQzFELGVBQWUsRUFBRTtvQkFDZix1QkFBYSxDQUFDLHdCQUF3QixDQUNwQyw0Q0FBNEMsQ0FDN0M7aUJBQ0Y7YUFDRixDQUFDLENBQUM7WUFFSCxNQUFNLGtCQUFrQixTQUFHLEtBQUssQ0FBQyxTQUFTLG1DQUFJO2dCQUM1QyxVQUFVLEVBQUUsb0JBQVUsQ0FBQyxNQUFNO2FBQzlCLENBQUM7WUFDRixNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsR0FBRztpQkFDMUIsYUFBYSxDQUFDLGtCQUFrQixDQUFDO2lCQUNqQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUNuQixRQUFRLEVBQUUsQ0FBQyxDQUFDLFFBQVE7YUFDckIsQ0FBQyxDQUFDLENBQUM7WUFFTixNQUFNLFlBQVksR0FBRyxJQUFJLHNCQUFZLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtnQkFDOUMsMEJBQTBCLEVBQUU7b0JBQzFCLHFCQUFxQixFQUFFO3dCQUNyQjs0QkFDRSwyQkFBMkIsRUFBRTtnQ0FDM0IsZ0JBQWdCLEVBQUUsRUFBRSxDQUFDLEdBQUc7Z0NBQ3hCLE9BQU8sRUFBRSxFQUFFLENBQUMsdUJBQXVCOzZCQUNwQzs0QkFDRCxTQUFTLEVBQUUsWUFBWTt5QkFDeEI7cUJBQ0Y7b0JBQ0QsWUFBWSxFQUFFLGFBQWEsQ0FBQyxPQUFPO29CQUNuQyxjQUFjLEVBQUUsQ0FBQztvQkFDakIsVUFBVSxFQUFFLFdBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO29CQUNoRSxnQ0FBZ0MsRUFBRSxJQUFJO2lCQUN2QzthQUNGLENBQUMsQ0FBQztZQUNILE1BQU0sT0FBTyxHQUFHLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO2dCQUNuRCxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztnQkFDckUsT0FBTyxFQUFFLGdCQUFnQjtnQkFDekIsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtnQkFDbEMsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2FBQzlCLENBQUMsQ0FBQztZQUVILE1BQU0sVUFBVSxHQUFHLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO2dCQUN6RCxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztnQkFDckUsT0FBTyxFQUFFLG1CQUFtQjtnQkFDNUIsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtnQkFDbEMsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2dCQUM3QixJQUFJLEVBQUUsT0FBTyxDQUFDLElBQUk7YUFDbkIsQ0FBQyxDQUFDO1lBRUgsTUFBTSxVQUFVLEdBQUcsSUFBSSxFQUFFLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7Z0JBQ3JELGNBQWMsRUFBRSxPQUFPO2dCQUN2QixpQkFBaUIsRUFBRSxVQUFVO2dCQUM3QixZQUFZLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPO2FBQ3pDLENBQUMsQ0FBQztZQUVILE9BQU8sQ0FBQyxlQUFlLENBQ3JCLElBQUkseUJBQWUsQ0FBQztnQkFDbEIsT0FBTyxFQUFFLENBQUMsZ0NBQWdDLENBQUM7Z0JBQzNDLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQzthQUNqQixDQUFDLENBQ0gsQ0FBQztZQUVGLE1BQU0sY0FBYyxHQUFHLElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFO2dCQUMvRCxZQUFZLEVBQUUsVUFBVSxDQUFDLFlBQVk7Z0JBQ3JDLFVBQVUsRUFBRTtvQkFDVixrQkFBa0IsRUFBRSxZQUFZLENBQUMsR0FBRztpQkFDckM7YUFDRixDQUFDLENBQUM7WUFFSCxjQUFjLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUNoRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsWUFBSyxDQUFDLFFBQVEsQ0FDdkMsY0FBYyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FDcEMsQ0FBQztZQUNGLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxZQUFLLENBQUMsUUFBUSxDQUN0QyxjQUFjLENBQUMsTUFBTSxDQUFDLHVCQUF1QixDQUFDLENBQy9DLENBQUM7WUFDRixJQUFJLGdCQUFTLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRSxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQyxDQUFDO1lBQ3ZFLElBQUksZ0JBQVMsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFLEVBQUUsS0FBSyxFQUFFLFlBQVksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1NBQ2pFO2FBQU07WUFDTCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksa0JBQVEsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUNsRCxZQUFZLEVBQUUsSUFBSSxzQkFBWSxDQUFDLE9BQU8sQ0FBQztnQkFDdkMsWUFBWSxFQUFFLGVBQWU7Z0JBQzdCLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztnQkFDYixVQUFVLFFBQUUsS0FBSyxDQUFDLFNBQVMsbUNBQUk7b0JBQzdCLFVBQVUsRUFBRSxvQkFBVSxDQUFDLE1BQU07aUJBQzlCO2dCQUNELFlBQVksRUFBRSxzQkFBWSxDQUFDLGlCQUFpQixDQUFDO29CQUMzQyxVQUFVLEVBQUUsK0JBQXFCLENBQUMsY0FBYztpQkFDakQsQ0FBQztnQkFDRixJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVU7Z0JBQ3JCLFFBQVEsRUFBRSxLQUFLO2dCQUNmLGFBQWEsRUFBRSxJQUFJLENBQUMsZUFBZTtnQkFDbkMsWUFBWSxFQUFFO29CQUNaO3dCQUNFLFVBQVUsRUFBRSxXQUFXO3dCQUN2QixNQUFNLEVBQUUsMkJBQWlCLENBQUMsR0FBRyxPQUFDLEtBQUssQ0FBQyxPQUFPLG1DQUFJLEVBQUUsQ0FBQztxQkFDbkQ7aUJBQ0Y7YUFDRixDQUFDLENBQUM7WUFDSCxJQUFJLGdCQUFTLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO2dCQUN4QyxLQUFLLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVO2FBQ2pDLENBQUMsQ0FBQztTQUNKO1FBRUQsTUFBTSx1QkFBdUIsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO1lBQ25GLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1lBQ3JFLE9BQU8sRUFBRSw0QkFBNEI7WUFDckMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUNsQyxPQUFPLEVBQUUsZUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7U0FDOUIsQ0FBQyxDQUFDO1FBRUgsTUFBTSx3QkFBd0IsR0FBRyxJQUFJLEVBQUUsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLDBCQUEwQixFQUFFO1lBQ2pGLGNBQWMsRUFBRSx1QkFBdUI7WUFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTztTQUN6QyxDQUFDLENBQUM7UUFFSCxNQUFNLGtCQUFrQixHQUFHLElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLEVBQUU7WUFDeEUsWUFBWSxFQUFFLGtDQUFrQztZQUNoRCxZQUFZLEVBQUUsd0JBQXdCLENBQUMsWUFBWTtZQUNuRCxVQUFVLEVBQUU7Z0JBQ1YsVUFBVSxFQUFFLFlBQVksQ0FBQyxVQUFVO2dCQUNuQyxTQUFTLEVBQUUsU0FBUzthQUNyQjtTQUNGLENBQUMsQ0FBQztRQUVILFlBQVksQ0FBQyxjQUFjLENBQUMsdUJBQXVCLENBQUMsQ0FBQztRQUNyRCxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQzlCLHVCQUFhLENBQUMsd0JBQXdCLENBQUMsOEJBQThCLENBQUMsQ0FDdkUsQ0FBQztRQUVGLElBQUksZ0JBQVMsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUU7WUFDckMsS0FBSyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTztTQUMvQixDQUFDLENBQUM7SUFDTCxDQUFDOzs7OztJQUtNLFdBQVcsQ0FBQyxRQUFrQjtRQUNuQyxNQUFNLElBQUksR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxHQUFHLFFBQVEsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQzFELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3ZDLENBQUM7SUFDTyxjQUFjLENBQUMsSUFBYztRQUNuQyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDeEIsQ0FBQztJQUNPLGlCQUFpQixDQUFDLFlBQXlDO1FBQ2pFLElBQUksVUFBVSxHQUFXLDhEQUE4RCxDQUFDO1FBQ3hGLElBQUksWUFBWSxFQUFFO1lBQ2hCLElBQUksUUFBUSxHQUFhLEVBQUUsQ0FBQztZQUM1QixZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFO2dCQUN2QixRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsSUFBSSxDQUFDLENBQUMsYUFBYSxHQUFHLENBQUMsQ0FBQztZQUN0RCxDQUFDLENBQUMsQ0FBQztZQUNILFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ25CLFVBQVUsR0FBRyxHQUFHLFVBQVUscUJBQXFCLENBQUMsRUFBRSxDQUFDO1lBQ3JELENBQUMsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxPQUFPLFVBQVUsQ0FBQztJQUNwQixDQUFDO0NBQ0Y7QUFuVEQsc0RBbVRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7XG4gIEluc3RhbmNlLFxuICBJbnN0YW5jZVR5cGUsXG4gIE1hY2hpbmVJbWFnZSxcbiAgVXNlckRhdGEsXG4gIEJsb2NrRGV2aWNlVm9sdW1lLFxuICBBbWF6b25MaW51eEdlbmVyYXRpb24sXG4gIFN1Ym5ldFR5cGUsXG4gIFZwYyxcbiAgSVZwYyxcbiAgSUluc3RhbmNlLFxuICBTZWN1cml0eUdyb3VwLFxuICBQb3J0LFxuICBDZm5MYXVuY2hUZW1wbGF0ZSxcbiAgQ2ZuU3BvdEZsZWV0LFxuICBJU2VjdXJpdHlHcm91cCxcbiAgU3VibmV0U2VsZWN0aW9uLFxufSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7XG4gIElSb2xlLFxuICBSb2xlLFxuICBTZXJ2aWNlUHJpbmNpcGFsLFxuICBNYW5hZ2VkUG9saWN5LFxuICBDZm5JbnN0YW5jZVByb2ZpbGUsXG4gIFBvbGljeVN0YXRlbWVudCxcbn0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBsb2dzIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJztcbmltcG9ydCB7IEJ1Y2tldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQge1xuICBDb25zdHJ1Y3QsXG4gIENmbk91dHB1dCxcbiAgRm4sXG4gIFN0YWNrLFxuICBEdXJhdGlvbixcbiAgTGF6eSxcbiAgQ3VzdG9tUmVzb3VyY2UsXG4gIFRva2VuLFxuICBSZW1vdmFsUG9saWN5LFxufSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNyIGZyb20gJ0Bhd3MtY2RrL2N1c3RvbS1yZXNvdXJjZXMnO1xuZXhwb3J0IGludGVyZmFjZSBEb2NrZXJWb2x1bWVzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBob3N0UGF0aDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb250YWluZXJQYXRoOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2l0bGFiQ29udGFpbmVyUnVubmVyUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGdpdGxhYnRva2VuOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlYzJ0eXBlPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZWxmdnBjPzogSVZwYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZWMyaWFtcm9sZT86IElSb2xlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRhZzE/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGFnMj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0YWczPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRhZ3M/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnaXRsYWJ1cmw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVic1NpemU/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BvdEZsZWV0PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGtleU5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYmxvY2tEdXJhdGlvbj86IEJsb2NrRHVyYXRpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpbnN0YW5jZUludGVycnVwdGlvbkJlaGF2aW9yPzogSW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZhbGlkVW50aWw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjU3VibmV0PzogU3VibmV0U2VsZWN0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZG9ja2VyVm9sdW1lcz86IERvY2tlclZvbHVtZXNbXTtcbn1cblxuZXhwb3J0IGVudW0gQmxvY2tEdXJhdGlvbiB7XG4gIE9ORV9IT1VSID0gNjAsXG4gIFRXT19IT1VSUyA9IDEyMCxcbiAgVEhSRUVfSE9VUlMgPSAxODAsXG4gIEZPVVJfSE9VUlMgPSAyNDAsXG4gIEZJVkVfSE9VUlMgPSAzMDAsXG4gIFNJWF9IT1VSUyA9IDM2MCxcbiAgU0VWRU5fSE9VUlMgPSA0MjAsXG4gIEVJR0hUX0hPVVJTID0gNDgwLFxuICBOSU5FX0hPVVJTID0gNTQwLFxuICBURU5fSE9VUlMgPSA2MDAsXG4gIEVMRVZFTl9IT1VSUyA9IDY2MCxcbiAgVFdFTFZFX0hPVVJTID0gNzIwLFxuICBUSElSVEVFTl9IT1VSUyA9IDc4MCxcbiAgRk9VUlRFRU5fSE9VUlMgPSA4NDAsXG4gIEZJRlRFRU5fSE9VUlMgPSA5MDAsXG4gIFNJWFRFRU5fSE9VUlMgPSA5NjAsXG4gIFNFVkVOVEVFTl9IT1VSUyA9IDEwMjAsXG4gIEVJR0hUVEVFTl9IT1VSUyA9IDEwODAsXG4gIE5JTkVURUVOX0hPVVJTID0gMTE0MCxcbiAgVFdFTlRZX0hPVVJTID0gMTIwMCxcbn1cblxuZXhwb3J0IGVudW0gSW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvciB7XG4gIEhJQkVSTkFURSA9ICdoaWJlcm5hdGUnLFxuICBTVE9QID0gJ3N0b3AnLFxuICBURVJNSU5BVEUgPSAndGVybWluYXRlJyxcbn1cblxuZXhwb3J0IGNsYXNzIEdpdGxhYkNvbnRhaW5lclJ1bm5lciBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgcnVubmVyUm9sZTogSVJvbGU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHJ1bm5lckVjMiE6IElJbnN0YW5jZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHZwYyE6IElWcGM7XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lIHdoZW4gdGhlIHRoZSBmbGVldCBhbGxvY2F0aW9uIHdpbGwgZXhwaXJlICwgISEhIG9ubHkgc3VwcG9ydCBzcG90ZmxlZXQgcnVubmVyICEhIVxuICAgKi9cbiAgcHJpdmF0ZSB2YWxpZFVudGlsPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgZGVmYXVsdFJ1bm5lclNHITogSVNlY3VyaXR5R3JvdXA7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBzcG90RmxlZXRSZXF1ZXN0SWQhOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNwb3RGbGVldEluc3RhbmNlSWQhOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdpdGxhYkNvbnRhaW5lclJ1bm5lclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzcG90RmxlZXRJZCA9IGlkO1xuICAgIGNvbnN0IHRva2VuID0gcHJvcHMuZ2l0bGFidG9rZW47XG4gICAgY29uc3QgdGFncyA9IHByb3BzLnRhZ3MgPz8gWydnaXRsYWInLCAnYXdzY2RrJywgJ3J1bm5lciddO1xuICAgIGNvbnN0IGdpdGxhYnVybCA9IHByb3BzLmdpdGxhYnVybCA/PyAnaHR0cHM6Ly9naXRsYWIuY29tLyc7XG4gICAgY29uc3QgZWMydHlwZSA9IHByb3BzLmVjMnR5cGUgPz8gJ3QzLm1pY3JvJztcbiAgICBjb25zdCBydW5uZXJCdWNrZXQgPSBuZXcgQnVja2V0KHRoaXMsICdydW5uZXJCdWNrZXQnLCB7XG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgfSk7XG4gICAgY29uc3Qgc2hlbGwgPSBVc2VyRGF0YS5mb3JMaW51eCgpO1xuICAgIHNoZWxsLmFkZENvbW1hbmRzKFxuICAgICAgJ3l1bSB1cGRhdGUgLXkgJyxcbiAgICAgICdzbGVlcCAxNSAmJiB5dW0gaW5zdGFsbCBkb2NrZXIgZ2l0IC15ICYmIHN5c3RlbWN0bCBzdGFydCBkb2NrZXIgJiYgdXNlcm1vZCAtYUcgZG9ja2VyIGVjMi11c2VyICYmIGNobW9kIDc3NyAvdmFyL3J1bi9kb2NrZXIuc29jaycsXG4gICAgICAnc3lzdGVtY3RsIHJlc3RhcnQgZG9ja2VyICYmIHN5c3RlbWN0bCBlbmFibGUgZG9ja2VyJyxcbiAgICAgICdkb2NrZXIgcnVuIC1kIC12IC9ob21lL2VjMi11c2VyLy5naXRsYWItcnVubmVyOi9ldGMvZ2l0bGFiLXJ1bm5lciAtdiAvdmFyL3J1bi9kb2NrZXIuc29jazovdmFyL3J1bi9kb2NrZXIuc29jayAtLW5hbWUgZ2l0bGFiLXJ1bm5lci1yZWdpc3RlciBnaXRsYWIvZ2l0bGFiLXJ1bm5lcjphbHBpbmUgcmVnaXN0ZXIgLS1ub24taW50ZXJhY3RpdmUgLS11cmwgJyArXG4gICAgICAgIGdpdGxhYnVybCArXG4gICAgICAgICcgLS1yZWdpc3RyYXRpb24tdG9rZW4gJyArXG4gICAgICAgIHRva2VuICtcbiAgICAgICAgJyAtLWRvY2tlci1wdWxsLXBvbGljeSBpZi1ub3QtcHJlc2VudCAnICsgdGhpcy5kb2NrZXJWb2x1bWVzTGlzdChwcm9wcz8uZG9ja2VyVm9sdW1lcykgKyAnIC0tZXhlY3V0b3IgZG9ja2VyIC0tZG9ja2VyLWltYWdlIFwiYWxwaW5lOmxhdGVzdFwiIC0tZGVzY3JpcHRpb24gXCJEb2NrZXIgUnVubmVyXCIgLS10YWctbGlzdCBcIicgK1xuICAgICAgICB0aGlzLnN5bnRoZXNpemVUYWdzKHRhZ3MpK1xuICAgICAgICAnXCIgLS1kb2NrZXItcHJpdmlsZWdlZCcsXG5cbiAgICAgICdzbGVlcCAyICYmIGRvY2tlciBydW4gLS1yZXN0YXJ0IGFsd2F5cyAtZCAtdiAvaG9tZS9lYzItdXNlci8uZ2l0bGFiLXJ1bm5lcjovZXRjL2dpdGxhYi1ydW5uZXIgLXYgL3Zhci9ydW4vZG9ja2VyLnNvY2s6L3Zhci9ydW4vZG9ja2VyLnNvY2sgLS1uYW1lIGdpdGxhYi1ydW5uZXIgZ2l0bGFiL2dpdGxhYi1ydW5uZXI6YWxwaW5lJyxcbiAgICAgICd1c2VybW9kIC1hRyBkb2NrZXIgc3NtLXVzZXInLFxuICAgICAgYFRPS0VOPSQoY2F0IC9ob21lL2VjMi11c2VyLy5naXRsYWItcnVubmVyL2NvbmZpZy50b21sIHwgZ3JlcCB0b2tlbiB8IGN1dCAtZCAnXCInIC1mIDIpICYmIGVjaG8gJ3tcInRva2VuXCI6IFwiVE9LRU5cIn0nID4gL3RtcC9ydW5uZXJ0b2tlbi50eHQgJiYgc2VkIC1pIHMvVE9LRU4vJFRPS0VOL2cgL3RtcC9ydW5uZXJ0b2tlbi50eHQgJiYgYXdzIHMzIGNwIC90bXAvcnVubmVydG9rZW4udHh0IHMzOi8vJHtydW5uZXJCdWNrZXQuYnVja2V0TmFtZX0vYCxcbiAgICApO1xuXG4gICAgdGhpcy5ydW5uZXJSb2xlID1cbiAgICAgIHByb3BzLmVjMmlhbXJvbGUgPz9cbiAgICAgIG5ldyBSb2xlKHRoaXMsICdydW5uZXItcm9sZScsIHtcbiAgICAgICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnZWMyLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgICAgZGVzY3JpcHRpb246ICdGb3IgR2l0bGFiIEVDMiBSdW5uZXIgUm9sZScsXG4gICAgICB9KTtcbiAgICB0aGlzLnZhbGlkVW50aWwgPSBwcm9wcy52YWxpZFVudGlsO1xuICAgIGNvbnN0IGluc3RhbmNlUHJvZmlsZSA9IG5ldyBDZm5JbnN0YW5jZVByb2ZpbGUodGhpcywgJ0luc3RhbmNlUHJvZmlsZScsIHtcbiAgICAgIHJvbGVzOiBbdGhpcy5ydW5uZXJSb2xlLnJvbGVOYW1lXSxcbiAgICB9KTtcbiAgICBydW5uZXJCdWNrZXQuZ3JhbnRXcml0ZSh0aGlzLnJ1bm5lclJvbGUpO1xuICAgIHRoaXMudnBjID1cbiAgICAgIHByb3BzLnNlbGZ2cGMgPz9cbiAgICAgIG5ldyBWcGModGhpcywgJ1ZQQycsIHtcbiAgICAgICAgY2lkcjogJzEwLjAuMC4wLzE2JyxcbiAgICAgICAgbWF4QXpzOiAyLFxuICAgICAgICBzdWJuZXRDb25maWd1cmF0aW9uOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgY2lkck1hc2s6IDI2LFxuICAgICAgICAgICAgbmFtZTogJ1J1bm5lclZQQycsXG4gICAgICAgICAgICBzdWJuZXRUeXBlOiBTdWJuZXRUeXBlLlBVQkxJQyxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBuYXRHYXRld2F5czogMCxcbiAgICAgIH0pO1xuICAgIHRoaXMuZGVmYXVsdFJ1bm5lclNHID0gbmV3IFNlY3VyaXR5R3JvdXAodGhpcywgJ1Nwb3RGbGVldFNnJywge1xuICAgICAgdnBjOiB0aGlzLnZwYyxcbiAgICB9KTtcbiAgICB0aGlzLmRlZmF1bHRSdW5uZXJTRy5jb25uZWN0aW9ucy5hbGxvd0Zyb21BbnlJcHY0KFBvcnQudGNwKDIyKSk7XG4gICAgY29uc3Qgc3BvdE9yT25EZW1hbmQgPSBwcm9wcy5zcG90RmxlZXQgPz8gZmFsc2U7XG4gICAgaWYgKHNwb3RPck9uRGVtYW5kKSB7XG4gICAgICAvL3Rocm93IG5ldyBFcnJvcigneWVzIG5ldyBzcG90ZmxlZXQnKTtcblxuICAgICAgY29uc3QgaW1hZ2VJZCA9IE1hY2hpbmVJbWFnZS5sYXRlc3RBbWF6b25MaW51eCh7XG4gICAgICAgIGdlbmVyYXRpb246IEFtYXpvbkxpbnV4R2VuZXJhdGlvbi5BTUFaT05fTElOVVhfMixcbiAgICAgIH0pLmdldEltYWdlKHRoaXMpLmltYWdlSWQ7XG4gICAgICBjb25zdCBsdCA9IG5ldyBDZm5MYXVuY2hUZW1wbGF0ZSh0aGlzLCAnTGF1bmNoVGVtcGxhdGUnLCB7XG4gICAgICAgIGxhdW5jaFRlbXBsYXRlRGF0YToge1xuICAgICAgICAgIGltYWdlSWQsXG4gICAgICAgICAgaW5zdGFuY2VUeXBlOiBlYzJ0eXBlLFxuICAgICAgICAgIGJsb2NrRGV2aWNlTWFwcGluZ3M6IFtcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgZGV2aWNlTmFtZTogJy9kZXYveHZkYScsXG4gICAgICAgICAgICAgIGViczoge1xuICAgICAgICAgICAgICAgIHZvbHVtZVNpemU6IHByb3BzLmVic1NpemUgPz8gNjAsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF0sXG4gICAgICAgICAgdXNlckRhdGE6IEZuLmJhc2U2NChzaGVsbC5yZW5kZXIoKSksXG4gICAgICAgICAga2V5TmFtZTogcHJvcHMua2V5TmFtZSxcbiAgICAgICAgICB0YWdTcGVjaWZpY2F0aW9uczogW1xuICAgICAgICAgICAge1xuICAgICAgICAgICAgICByZXNvdXJjZVR5cGU6ICdpbnN0YW5jZScsXG4gICAgICAgICAgICAgIHRhZ3M6IFtcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICBrZXk6ICdOYW1lJyxcbiAgICAgICAgICAgICAgICAgIHZhbHVlOiBgJHtcbiAgICAgICAgICAgICAgICAgICAgU3RhY2sub2YodGhpcykuc3RhY2tOYW1lXG4gICAgICAgICAgICAgICAgICB9L3Nwb3RGbGVldEdpdGxhYlJ1bm5lci8ke3Nwb3RGbGVldElkfWAsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgXSxcbiAgICAgICAgICBpbnN0YW5jZU1hcmtldE9wdGlvbnM6IHtcbiAgICAgICAgICAgIG1hcmtldFR5cGU6ICdzcG90JyxcbiAgICAgICAgICAgIHNwb3RPcHRpb25zOiB7XG4gICAgICAgICAgICAgIGJsb2NrRHVyYXRpb25NaW51dGVzOlxuICAgICAgICAgICAgICAgIHByb3BzLmJsb2NrRHVyYXRpb24gPz8gQmxvY2tEdXJhdGlvbi5PTkVfSE9VUixcbiAgICAgICAgICAgICAgaW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvcjpcbiAgICAgICAgICAgICAgICBwcm9wcy5pbnN0YW5jZUludGVycnVwdGlvbkJlaGF2aW9yID8/XG4gICAgICAgICAgICAgICAgSW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvci5URVJNSU5BVEUsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgICAgc2VjdXJpdHlHcm91cElkczogdGhpcy5kZWZhdWx0UnVubmVyU0cuY29ubmVjdGlvbnMuc2VjdXJpdHlHcm91cHMubWFwKFxuICAgICAgICAgICAgKG0pID0+IG0uc2VjdXJpdHlHcm91cElkLFxuICAgICAgICAgICksXG4gICAgICAgICAgaWFtSW5zdGFuY2VQcm9maWxlOiB7XG4gICAgICAgICAgICBhcm46IGluc3RhbmNlUHJvZmlsZS5hdHRyQXJuLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9KTtcblxuICAgICAgY29uc3Qgc3BvdEZsZWV0Um9sZSA9IG5ldyBSb2xlKHRoaXMsICdGbGVldFJvbGUnLCB7XG4gICAgICAgIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ3Nwb3RmbGVldC5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIG1hbmFnZWRQb2xpY2llczogW1xuICAgICAgICAgIE1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKFxuICAgICAgICAgICAgJ3NlcnZpY2Utcm9sZS9BbWF6b25FQzJTcG90RmxlZXRUYWdnaW5nUm9sZScsXG4gICAgICAgICAgKSxcbiAgICAgICAgXSxcbiAgICAgIH0pO1xuXG4gICAgICBjb25zdCB2cGNTdWJuZXRTZWxlY3Rpb24gPSBwcm9wcy52cGNTdWJuZXQgPz8ge1xuICAgICAgICBzdWJuZXRUeXBlOiBTdWJuZXRUeXBlLlBVQkxJQyxcbiAgICAgIH07XG4gICAgICBjb25zdCBzdWJuZXRDb25maWcgPSB0aGlzLnZwY1xuICAgICAgICAuc2VsZWN0U3VibmV0cyh2cGNTdWJuZXRTZWxlY3Rpb24pXG4gICAgICAgIC5zdWJuZXRzLm1hcCgocykgPT4gKHtcbiAgICAgICAgICBzdWJuZXRJZDogcy5zdWJuZXRJZCxcbiAgICAgICAgfSkpO1xuXG4gICAgICBjb25zdCBjZm5TcG90RmxlZXQgPSBuZXcgQ2ZuU3BvdEZsZWV0KHRoaXMsIGlkLCB7XG4gICAgICAgIHNwb3RGbGVldFJlcXVlc3RDb25maWdEYXRhOiB7XG4gICAgICAgICAgbGF1bmNoVGVtcGxhdGVDb25maWdzOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIGxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbjoge1xuICAgICAgICAgICAgICAgIGxhdW5jaFRlbXBsYXRlSWQ6IGx0LnJlZixcbiAgICAgICAgICAgICAgICB2ZXJzaW9uOiBsdC5hdHRyTGF0ZXN0VmVyc2lvbk51bWJlcixcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgb3ZlcnJpZGVzOiBzdWJuZXRDb25maWcsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF0sXG4gICAgICAgICAgaWFtRmxlZXRSb2xlOiBzcG90RmxlZXRSb2xlLnJvbGVBcm4sXG4gICAgICAgICAgdGFyZ2V0Q2FwYWNpdHk6IDEsXG4gICAgICAgICAgdmFsaWRVbnRpbDogTGF6eS5zdHJpbmdWYWx1ZSh7IHByb2R1Y2U6ICgpID0+IHRoaXMudmFsaWRVbnRpbCB9KSxcbiAgICAgICAgICB0ZXJtaW5hdGVJbnN0YW5jZXNXaXRoRXhwaXJhdGlvbjogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgICAgY29uc3Qgb25FdmVudCA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ09uRXZlbnQnLCB7XG4gICAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vZ2V0aW5zdGFuY2VJZCcpKSxcbiAgICAgICAgaGFuZGxlcjogJ2luZGV4Lm9uX2V2ZW50JyxcbiAgICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgICAgdGltZW91dDogRHVyYXRpb24uc2Vjb25kcyg2MCksXG4gICAgICB9KTtcblxuICAgICAgY29uc3QgaXNDb21wbGV0ZSA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ0lzQ29tcGxldGUnLCB7XG4gICAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vZ2V0aW5zdGFuY2VJZCcpKSxcbiAgICAgICAgaGFuZGxlcjogJ2luZGV4LmlzX2NvbXBsZXRlJyxcbiAgICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgICAgdGltZW91dDogRHVyYXRpb24uc2Vjb25kcyg2MCksXG4gICAgICAgIHJvbGU6IG9uRXZlbnQucm9sZSxcbiAgICAgIH0pO1xuXG4gICAgICBjb25zdCBteVByb3ZpZGVyID0gbmV3IGNyLlByb3ZpZGVyKHRoaXMsICdNeVByb3ZpZGVyJywge1xuICAgICAgICBvbkV2ZW50SGFuZGxlcjogb25FdmVudCxcbiAgICAgICAgaXNDb21wbGV0ZUhhbmRsZXI6IGlzQ29tcGxldGUsXG4gICAgICAgIGxvZ1JldGVudGlvbjogbG9ncy5SZXRlbnRpb25EYXlzLk9ORV9EQVksXG4gICAgICB9KTtcblxuICAgICAgb25FdmVudC5hZGRUb1JvbGVQb2xpY3koXG4gICAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGFjdGlvbnM6IFsnZWMyOkRlc2NyaWJlU3BvdEZsZWV0SW5zdGFuY2VzJ10sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgICAgfSksXG4gICAgICApO1xuXG4gICAgICBjb25zdCBmbGVldEluc3RhbmNlcyA9IG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnR2V0SW5zdGFuY2VJZCcsIHtcbiAgICAgICAgc2VydmljZVRva2VuOiBteVByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgIFNwb3RGbGVldFJlcXVlc3RJZDogY2ZuU3BvdEZsZWV0LnJlZixcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuXG4gICAgICBmbGVldEluc3RhbmNlcy5ub2RlLmFkZERlcGVuZGVuY3koY2ZuU3BvdEZsZWV0KTtcbiAgICAgIHRoaXMuc3BvdEZsZWV0SW5zdGFuY2VJZCA9IFRva2VuLmFzU3RyaW5nKFxuICAgICAgICBmbGVldEluc3RhbmNlcy5nZXRBdHQoJ0luc3RhbmNlSWQnKSxcbiAgICAgICk7XG4gICAgICB0aGlzLnNwb3RGbGVldFJlcXVlc3RJZCA9IFRva2VuLmFzU3RyaW5nKFxuICAgICAgICBmbGVldEluc3RhbmNlcy5nZXRBdHQoJ1Nwb3RJbnN0YW5jZVJlcXVlc3RJZCcpLFxuICAgICAgKTtcbiAgICAgIG5ldyBDZm5PdXRwdXQodGhpcywgJ0luc3RhbmNlSWQnLCB7IHZhbHVlOiB0aGlzLnNwb3RGbGVldEluc3RhbmNlSWQgfSk7XG4gICAgICBuZXcgQ2ZuT3V0cHV0KHRoaXMsICdTcG90RmxlZXRJZCcsIHsgdmFsdWU6IGNmblNwb3RGbGVldC5yZWYgfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucnVubmVyRWMyID0gbmV3IEluc3RhbmNlKHRoaXMsICdHaXRsYWJSdW5uZXInLCB7XG4gICAgICAgIGluc3RhbmNlVHlwZTogbmV3IEluc3RhbmNlVHlwZShlYzJ0eXBlKSxcbiAgICAgICAgaW5zdGFuY2VOYW1lOiAnR2l0bGFiLVJ1bm5lcicsXG4gICAgICAgIHZwYzogdGhpcy52cGMsXG4gICAgICAgIHZwY1N1Ym5ldHM6IHByb3BzLnZwY1N1Ym5ldCA/PyB7XG4gICAgICAgICAgc3VibmV0VHlwZTogU3VibmV0VHlwZS5QVUJMSUMsXG4gICAgICAgIH0sXG4gICAgICAgIG1hY2hpbmVJbWFnZTogTWFjaGluZUltYWdlLmxhdGVzdEFtYXpvbkxpbnV4KHtcbiAgICAgICAgICBnZW5lcmF0aW9uOiBBbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYXzIsXG4gICAgICAgIH0pLFxuICAgICAgICByb2xlOiB0aGlzLnJ1bm5lclJvbGUsXG4gICAgICAgIHVzZXJEYXRhOiBzaGVsbCxcbiAgICAgICAgc2VjdXJpdHlHcm91cDogdGhpcy5kZWZhdWx0UnVubmVyU0csXG4gICAgICAgIGJsb2NrRGV2aWNlczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIGRldmljZU5hbWU6ICcvZGV2L3h2ZGEnLFxuICAgICAgICAgICAgdm9sdW1lOiBCbG9ja0RldmljZVZvbHVtZS5lYnMocHJvcHMuZWJzU2l6ZSA/PyA2MCksXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0pO1xuICAgICAgbmV3IENmbk91dHB1dCh0aGlzLCAnUnVubmVyLUluc3RhbmNlLUlEJywge1xuICAgICAgICB2YWx1ZTogdGhpcy5ydW5uZXJFYzIuaW5zdGFuY2VJZCxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGNvbnN0IHVucmVnaXN0ZXJSdW5uZXJPbkV2ZW50ID0gbmV3IGxhbWJkYS5GdW5jdGlvbih0aGlzLCAndW5yZWdpc3RlclJ1bm5lck9uRXZlbnQnLCB7XG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uL2dldGluc3RhbmNlSWQnKSksXG4gICAgICBoYW5kbGVyOiAndW5yZWdpc3Rlcl9ydW5uZXIub25fZXZlbnQnLFxuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgIH0pO1xuXG4gICAgY29uc3QgdW5yZWdpc3RlclJ1bm5lclByb3ZpZGVyID0gbmV3IGNyLlByb3ZpZGVyKHRoaXMsICd1bnJlZ2lzdGVyUnVubmVyUHJvdmlkZXInLCB7XG4gICAgICBvbkV2ZW50SGFuZGxlcjogdW5yZWdpc3RlclJ1bm5lck9uRXZlbnQsXG4gICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfREFZLFxuICAgIH0pO1xuXG4gICAgY29uc3QgdW5yZWdpc3RlclJ1bm5lckNSID0gbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICd1bnJlZ2lzdGVyUnVubmVyQ1InLCB7XG4gICAgICByZXNvdXJjZVR5cGU6ICdDdXN0b206OnVucmVnaXN0ZXJSdW5uZXJQcm92aWRlcicsXG4gICAgICBzZXJ2aWNlVG9rZW46IHVucmVnaXN0ZXJSdW5uZXJQcm92aWRlci5zZXJ2aWNlVG9rZW4sXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIEJ1Y2tldE5hbWU6IHJ1bm5lckJ1Y2tldC5idWNrZXROYW1lLFxuICAgICAgICBHaXRsYWJVcmw6IGdpdGxhYnVybCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBydW5uZXJCdWNrZXQuZ3JhbnRSZWFkV3JpdGUodW5yZWdpc3RlclJ1bm5lck9uRXZlbnQpO1xuICAgIHVucmVnaXN0ZXJSdW5uZXJDUi5ub2RlLmFkZERlcGVuZGVuY3kocnVubmVyQnVja2V0KTtcbiAgICB0aGlzLnJ1bm5lclJvbGUuYWRkTWFuYWdlZFBvbGljeShcbiAgICAgIE1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlJyksXG4gICAgKTtcblxuICAgIG5ldyBDZm5PdXRwdXQodGhpcywgJ1J1bm5lci1Sb2xlLUFybicsIHtcbiAgICAgIHZhbHVlOiB0aGlzLnJ1bm5lclJvbGUucm9sZUFybixcbiAgICB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBleHBpcmVBZnRlcihkdXJhdGlvbjogRHVyYXRpb24pIHtcbiAgICBjb25zdCBkYXRlID0gbmV3IERhdGUoKTtcbiAgICBkYXRlLnNldFNlY29uZHMoZGF0ZS5nZXRTZWNvbmRzKCkgKyBkdXJhdGlvbi50b1NlY29uZHMoKSk7XG4gICAgdGhpcy52YWxpZFVudGlsID0gZGF0ZS50b0lTT1N0cmluZygpO1xuICB9XG4gIHByaXZhdGUgc3ludGhlc2l6ZVRhZ3ModGFnczogc3RyaW5nW10pOiBzdHJpbmcge1xuICAgIHJldHVybiB0YWdzLmpvaW4oJywnKTtcbiAgfVxuICBwcml2YXRlIGRvY2tlclZvbHVtZXNMaXN0KGRvY2tlclZvbHVtZTogRG9ja2VyVm9sdW1lc1tdIHwgdW5kZWZpbmVkKTogc3RyaW5nIHtcbiAgICBsZXQgdGVtcFN0cmluZyA6c3RyaW5nID0gJy0tZG9ja2VyLXZvbHVtZXMgXCIvdmFyL3J1bi9kb2NrZXIuc29jazovdmFyL3J1bi9kb2NrZXIuc29ja1wiJztcbiAgICBpZiAoZG9ja2VyVm9sdW1lKSB7XG4gICAgICBsZXQgdGVtcExpc3QgOnN0cmluZ1tdID0gW107XG4gICAgICBkb2NrZXJWb2x1bWUuZm9yRWFjaChlID0+IHtcbiAgICAgICAgdGVtcExpc3QucHVzaChgXCIke2UuaG9zdFBhdGh9OiR7ZS5jb250YWluZXJQYXRofVwiYCk7XG4gICAgICB9KTtcbiAgICAgIHRlbXBMaXN0LmZvckVhY2goZSA9PiB7XG4gICAgICAgIHRlbXBTdHJpbmcgPSBgJHt0ZW1wU3RyaW5nfSAtLWRvY2tlci12b2x1bWVzICR7ZX1gO1xuICAgICAgfSk7XG4gICAgfVxuICAgIHJldHVybiB0ZW1wU3RyaW5nO1xuICB9XG59XG4iXX0=