# Generated by Django 4.2.10 on 2024-07-18 09:22

from django.db import migrations, models
import django.db.models.deletion
import recurrence.fields


def _create_lesson_bundles(apps, schema_editor):
    Lesson = apps.get_model("lesrooster", "Lesson")
    LessonBundle = apps.get_model("lesrooster", "LessonBundle")
    CourseBundle = apps.get_model("cursus", "CourseBundle")
    db_alias = schema_editor.connection.alias
    for lesson in Lesson.objects.using(db_alias).all():
        # Duplicated from models.py LessonBundle.create_from_course_bundle
        # because the historical model used here does not have this method.
        app_label = CourseBundle._meta.app_label
        course_bundle = lesson.course.bundle.get(courses__pk=lesson.course.pk, managed_by_app_label=app_label)
        lesson_bundle = LessonBundle.objects.create(
            course_bundle=course_bundle,
            slot_start=lesson.slot_start,
            slot_end=lesson.slot_end,
            recurrence=lesson.recurrence
        )
        lesson_bundle.lessons.set([lesson])


class Migration(migrations.Migration):

    dependencies = [
        ('lesrooster', '0018_uniform_tcc'),
        ('cursus', '0004_add_course_bundle'),
    ]

    operations = [
        migrations.CreateModel(
            name='LessonBundle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('managed_by_app_label', models.CharField(blank=True, editable=False, max_length=255, verbose_name='App label of app responsible for managing this instance')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('recurrence', recurrence.fields.RecurrenceField(blank=True, help_text='Leave empty for a single lesson.', null=True, verbose_name='Recurrence')),
                ('course_bundle', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lesson_bundle', to='cursus.coursebundle', verbose_name='Bundled lessons')),
                ('lessons', models.ManyToManyField(related_name='bundle', to='lesrooster.lesson', verbose_name='Bundled lessons')),
                ('slot_end', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='lesrooster.slot', verbose_name='End slot')),
                ('slot_start', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='lesrooster.slot', verbose_name='Start slot')),
            ],
            options={
                'verbose_name': 'Lesson bundle',
                'verbose_name_plural': 'Lesson bundles',
                'ordering': (['slot_start__time_grid__validity_range__date_start', 'slot_start__weekday', 'slot_start__time_start'],),
            },
        ),
        migrations.RunPython(_create_lesson_bundles),
        migrations.AlterModelOptions(
            name='lesson',
            options={'ordering': ['subject'], 'verbose_name': 'Lesson', 'verbose_name_plural': 'Lessons'},
        ),
        migrations.RemoveField(
            model_name='lesson',
            name='recurrence',
        ),
        migrations.RemoveField(
            model_name='lesson',
            name='slot_end',
        ),
        migrations.RemoveField(
            model_name='lesson',
            name='slot_start',
        ),
    ]
