# Generated by Django 4.2.4 on 2023-08-14 18:44

from django.db import migrations, models
import django.db.models.deletion

def _migrate_values(apps, schema_editor):
    TimeGrid = apps.get_model("lesrooster", "TimeGrid")
    Slot = apps.get_model("lesrooster", "Slot")

    for slot in Slot.objects.all():
        tgs = TimeGrid.objects.filter(validity_range=slot.validity_range)
        if tgs:
            tg = tgs.first()
        else:
            tg = TimeGrid.objects.create(validity_range=slot.validity_range)
        slot.time_grid = tg
        slot.save()


class Migration(migrations.Migration):

    dependencies = [
        ("lesrooster", "0004_slot_timegrid"),
    ]

    operations = [
        migrations.RunPython(_migrate_values),
    ]
