# Generated by Django 4.2.3 on 2023-07-31 12:12

import aleksis.core.managers
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0052_site_related_name"),
        ("cursus", "0001_initial"),
        ("lesrooster", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="TimeboundCourseConfig",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                (
                    "scheduled_slot_count",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Number of slots this course is scheduled to fill per week",
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lr_timebound_course_configs",
                        to="cursus.course",
                        verbose_name="Course",
                    ),
                ),
                (
                    "teachers",
                    models.ManyToManyField(
                        related_name="lr_timebound_course_configs",
                        to="core.person",
                        verbose_name="Teachers",
                    ),
                ),
                (
                    "validity_range",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lr_timebound_course_configs",
                        to="lesrooster.validityrange",
                        verbose_name="Linked validity range",
                    ),
                ),
            ],
            options={
                "verbose_name": "Timebound course config",
                "verbose_name_plural": "Timebound course configs",
            },
            managers=[
                ("objects", aleksis.core.managers.AlekSISBaseManager()),
            ],
        ),
        migrations.AddConstraint(
            model_name="timeboundcourseconfig",
            constraint=models.UniqueConstraint(
                fields=("course", "validity_range"), name="lr_unique_course_config_per_range"
            ),
        ),
    ]
