# Generated by Django 4.2.3 on 2023-07-31 08:36

import aleksis.apps.chronos.managers
import aleksis.core.managers
from django.db import migrations, models
import django.db.models.deletion
import recurrence.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("core", "0052_site_related_name"),
        ("contenttypes", "0002_remove_content_type_name"),
        ("chronos", "0016_lessonevent"),
        ("cursus", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Lesson",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                (
                    "recurrence",
                    recurrence.fields.RecurrenceField(
                        blank=True,
                        help_text="Leave empty for a single lesson.",
                        null=True,
                        verbose_name="Recurrence",
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="cursus.course",
                        verbose_name="Course",
                    ),
                ),
                (
                    "lesson_event",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="lesson",
                        to="chronos.lessonevent",
                        verbose_name="Linked lesson event",
                    ),
                ),
                (
                    "rooms",
                    models.ManyToManyField(
                        blank=True, related_name="lr_lessons", to="core.room", verbose_name="Rooms"
                    ),
                ),
            ],
            options={
                "verbose_name": "Lesson",
                "verbose_name_plural": "Lessons",
                "ordering": [
                    "slot_start__validity_range__date_start",
                    "slot_start__weekday",
                    "slot_start__time_start",
                    "subject",
                ],
            },
            bases=(models.Model,),
            managers=[
                ("objects", aleksis.core.managers.AlekSISBaseManager()),
            ],
        ),
        migrations.CreateModel(
            name="Slot",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                ("name", models.CharField(blank=True, max_length=255, verbose_name="Name")),
                (
                    "weekday",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Monday"),
                            (1, "Tuesday"),
                            (2, "Wednesday"),
                            (3, "Thursday"),
                            (4, "Friday"),
                            (5, "Saturday"),
                            (6, "Sunday"),
                        ],
                        verbose_name="Week day",
                    ),
                ),
                (
                    "period",
                    models.PositiveSmallIntegerField(
                        blank=True, null=True, verbose_name="Number of period"
                    ),
                ),
                ("time_start", models.TimeField(verbose_name="Start time")),
                ("time_end", models.TimeField(verbose_name="End time")),
                (
                    "polymorphic_ctype",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="polymorphic_%(app_label)s.%(class)s_set+",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Slot",
                "verbose_name_plural": "Slots",
                "ordering": ["weekday", "period"],
            },
        ),
        migrations.CreateModel(
            name="Supervision",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                (
                    "recurrence",
                    recurrence.fields.RecurrenceField(
                        blank=True,
                        help_text="Leave empty for a single supervision.",
                        null=True,
                        verbose_name="Recurrence",
                    ),
                ),
                (
                    "rooms",
                    models.ManyToManyField(
                        related_name="lr_supervisions", to="core.room", verbose_name="Rooms"
                    ),
                ),
                (
                    "supervision_event",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="supervision",
                        to="chronos.supervisionevent",
                        verbose_name="Linked supervision event",
                    ),
                ),
                (
                    "teachers",
                    models.ManyToManyField(
                        related_name="lr_supervisions", to="core.person", verbose_name="Teachers"
                    ),
                ),
            ],
            options={
                "verbose_name": "Supervision",
                "verbose_name_plural": "Supervisions",
            },
            bases=(models.Model,),
            managers=[
                ("objects", aleksis.core.managers.AlekSISBaseManager()),
            ],
        ),
        migrations.CreateModel(
            name="BreakSlot",
            fields=[
                (
                    "slot_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="lesrooster.slot",
                    ),
                ),
                ("period_after", models.IntegerField(verbose_name="Period after")),
            ],
            options={
                "verbose_name": "Break",
                "verbose_name_plural": "Breaks",
            },
            bases=("lesrooster.slot",),
        ),
        migrations.CreateModel(
            name="ValidityRange",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                ("name", models.CharField(blank=True, max_length=255, verbose_name="Name")),
                ("date_start", models.DateField(verbose_name="Start date")),
                ("date_end", models.DateField(verbose_name="End date")),
                (
                    "status",
                    models.CharField(
                        choices=[("draft", "Draft"), ("published", "Published")],
                        default="draft",
                        max_length=255,
                        verbose_name="Status",
                    ),
                ),
                (
                    "school_term",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lr_validity_ranges",
                        to="core.schoolterm",
                        verbose_name="School term",
                    ),
                ),
            ],
            options={
                "verbose_name": "Validity range",
                "verbose_name_plural": "Validity ranges",
            },
        ),
        migrations.CreateModel(
            name="SupervisionSubstitution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                ("date", models.DateField(verbose_name="Date")),
                ("cancelled", models.BooleanField(default=False, verbose_name="Cancelled?")),
                ("comment", models.TextField(blank=True, verbose_name="Comment")),
                (
                    "supervision",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="substitutions",
                        to="lesrooster.supervision",
                        verbose_name="Supervision",
                    ),
                ),
                (
                    "supervision_event",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="supervision_substitution",
                        to="chronos.supervisionevent",
                        verbose_name="Linked supervision event",
                    ),
                ),
                (
                    "teachers",
                    models.ManyToManyField(
                        blank=True,
                        related_name="lr_supervision_substitutions",
                        to="core.person",
                        verbose_name="Teachers",
                    ),
                ),
            ],
            options={
                "verbose_name": "Supervision Substitution",
                "verbose_name_plural": "Supervision Substitutions",
                "ordering": [
                    "date",
                    "supervision__break_slot__weekday",
                    "supervision__break_slot__period",
                ],
            },
            bases=(models.Model,),
            managers=[
                ("objects", aleksis.core.managers.AlekSISBaseManager()),
            ],
        ),
        migrations.CreateModel(
            name="Substitution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "managed_by_app_label",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=255,
                        verbose_name="App label of app responsible for managing this instance",
                    ),
                ),
                ("extended_data", models.JSONField(default=dict, editable=False)),
                ("date", models.DateField(verbose_name="Date")),
                ("cancelled", models.BooleanField(default=False, verbose_name="Cancelled?")),
                ("comment", models.TextField(blank=True, verbose_name="Comment")),
                (
                    "lesson",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="substitutions",
                        to="lesrooster.lesson",
                        verbose_name="Lesson",
                    ),
                ),
                (
                    "lesson_event",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="substitution",
                        to="chronos.lessonevent",
                        verbose_name="Linked lesson event",
                    ),
                ),
                (
                    "rooms",
                    models.ManyToManyField(
                        blank=True,
                        related_name="lr_substitutions",
                        to="core.room",
                        verbose_name="Rooms",
                    ),
                ),
                (
                    "subject",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="substitutions",
                        to="cursus.subject",
                        verbose_name="Subject",
                    ),
                ),
                (
                    "teachers",
                    models.ManyToManyField(
                        blank=True,
                        related_name="lr_substitutions",
                        to="core.person",
                        verbose_name="Teachers",
                    ),
                ),
            ],
            options={
                "verbose_name": "Substitution",
                "verbose_name_plural": "Substitutions",
                "ordering": ["date", "lesson__slot_start__weekday", "lesson__slot_start__period"],
            },
            bases=(models.Model,),
            managers=[
                ("objects", aleksis.core.managers.AlekSISBaseManager()),
            ],
        ),
        migrations.AddField(
            model_name="slot",
            name="validity_range",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lr_slots",
                to="lesrooster.validityrange",
                verbose_name="Linked validity range",
            ),
        ),
        migrations.AddField(
            model_name="lesson",
            name="slot_end",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="lesrooster.slot",
                verbose_name="End slot",
            ),
        ),
        migrations.AddField(
            model_name="lesson",
            name="slot_start",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="lesrooster.slot",
                verbose_name="Start slot",
            ),
        ),
        migrations.AddField(
            model_name="lesson",
            name="subject",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lr_lessons",
                to="cursus.subject",
                verbose_name="Subject",
            ),
        ),
        migrations.AddField(
            model_name="lesson",
            name="teachers",
            field=models.ManyToManyField(
                blank=True,
                related_name="lr_lessons_as_teacher",
                to="core.person",
                verbose_name="Teachers",
            ),
        ),
        migrations.AddIndex(
            model_name="validityrange",
            index=models.Index(
                fields=["date_start", "date_end"], name="lr_validity_date_start_end"
            ),
        ),
        migrations.AddConstraint(
            model_name="validityrange",
            constraint=models.UniqueConstraint(
                fields=("school_term", "date_start", "date_end"), name="lr_unique_dates_per_term"
            ),
        ),
        migrations.AddIndex(
            model_name="supervisionsubstitution",
            index=models.Index(fields=["date"], name="super_substitution_date"),
        ),
        migrations.AddIndex(
            model_name="supervisionsubstitution",
            index=models.Index(fields=["supervision"], name="super_substitution_supervision"),
        ),
        migrations.AddField(
            model_name="supervision",
            name="break_slot",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lr_supervisions",
                to="lesrooster.breakslot",
                verbose_name="Break Slot",
            ),
        ),
        migrations.AddIndex(
            model_name="substitution",
            index=models.Index(fields=["date"], name="substitution_date"),
        ),
        migrations.AddIndex(
            model_name="substitution",
            index=models.Index(fields=["lesson"], name="substitution_lesson"),
        ),
        migrations.AddConstraint(
            model_name="substitution",
            constraint=models.CheckConstraint(
                check=models.Q(("cancelled", True), ("subject__isnull", False), _negated=True),
                name="lr_either_substituted_or_cancelled",
            ),
        ),
        migrations.AddConstraint(
            model_name="substitution",
            constraint=models.UniqueConstraint(
                fields=("lesson", "date"), name="unique_lesson_per_date"
            ),
        ),
        migrations.AddIndex(
            model_name="slot",
            index=models.Index(
                fields=["time_start", "time_end"], name="lesrooster__time_st_8ec433_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="slot",
            constraint=models.UniqueConstraint(
                fields=("weekday", "period", "validity_range"), name="lr_unique_period_per_range"
            ),
        ),
    ]
