"use strict";
const lib_1 = require("../lib");
const util_1 = require("../lib/util");
class SomeToken {
    constructor() {
        this.foo = 60;
        this.goo = 40;
    }
    resolve() {
        return this.foo + this.goo;
    }
}
module.exports = {
    'capitalizeResourceProperties capitalizes all keys of an object (recursively) from camelCase to PascalCase'(test) {
        const c = new lib_1.App();
        test.equal(util_1.capitalizePropertyNames(c, undefined), undefined);
        test.equal(util_1.capitalizePropertyNames(c, 12), 12);
        test.equal(util_1.capitalizePropertyNames(c, 'hello'), 'hello');
        test.deepEqual(util_1.capitalizePropertyNames(c, ['hello', 88]), ['hello', 88]);
        test.deepEqual(util_1.capitalizePropertyNames(c, { Hello: 'world', hey: 'dude' }), { Hello: 'world', Hey: 'dude' });
        test.deepEqual(util_1.capitalizePropertyNames(c, [1, 2, { three: 3 }]), [1, 2, { Three: 3 }]);
        test.deepEqual(util_1.capitalizePropertyNames(c, { Hello: 'world', recursive: { foo: 123, there: { another: ['hello', { world: 123 }] } } }), { Hello: 'world', Recursive: { Foo: 123, There: { Another: ['hello', { World: 123 }] } } });
        // make sure tokens are resolved and result is also capitalized
        test.deepEqual(util_1.capitalizePropertyNames(c, { hello: { resolve: () => ({ foo: 'bar' }) }, world: new SomeToken() }), { Hello: { Foo: 'bar' }, World: 100 });
        test.done();
    },
    'ignoreEmpty': {
        '[]'(test) {
            const c = new lib_1.App();
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty([])), undefined);
            test.done();
        },
        '{}'(test) {
            const c = new lib_1.App();
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty({})), undefined);
            test.done();
        },
        'undefined/null'(test) {
            const c = new lib_1.App();
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty(undefined)), undefined);
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty(null)), null);
            test.done();
        },
        'primitives'(test) {
            const c = new lib_1.App();
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty(12)), 12);
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty("12")), "12");
            test.done();
        },
        'non-empty arrays/objects'(test) {
            const c = new lib_1.App();
            test.deepEqual(c.node.resolve(util_1.ignoreEmpty([1, 2, 3, undefined])), [1, 2, 3]); // undefined array values is cleaned up by "resolve"
            test.deepEqual(c.node.resolve(util_1.ignoreEmpty({ o: 1, b: 2, j: 3 })), { o: 1, b: 2, j: 3 });
            test.done();
        },
        'resolve first'(test) {
            const c = new lib_1.App();
            test.deepEqual(c.node.resolve(util_1.ignoreEmpty({ xoo: { resolve: () => 123 } })), { xoo: 123 });
            test.strictEqual(c.node.resolve(util_1.ignoreEmpty({ xoo: { resolve: () => undefined } })), undefined);
            test.deepEqual(c.node.resolve(util_1.ignoreEmpty({ xoo: { resolve: () => [] } })), { xoo: [] });
            test.deepEqual(c.node.resolve(util_1.ignoreEmpty({ xoo: { resolve: () => [undefined, undefined] } })), { xoo: [] });
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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