"use strict";
const lib_1 = require("../lib");
module.exports = {
    'plainText'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.plainText('this just resolves to a string');
        // THEN
        test.deepEqual(stack.node.resolve(v), 'this just resolves to a string');
        test.done();
    },
    'secretsManager'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id', {
            jsonField: 'json-key',
            versionId: 'version-id',
            versionStage: 'version-stage'
        });
        // THEN
        test.deepEqual(stack.node.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:json-key:version-stage:version-id}}');
        test.done();
    },
    'secretsManager with defaults'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id');
        // THEN
        test.deepEqual(stack.node.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:::}}');
        test.done();
    },
    'secretsManager with an empty ID'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager(''), /secretId cannot be empty/);
        test.done();
    },
    'ssmSecure'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.ssmSecure('param-name', 'param-version');
        // THEN
        test.deepEqual(stack.node.resolve(v), '{{resolve:ssm-secure:param-name:param-version}}');
        test.done();
    },
    'cfnDynamicReference'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.cfnDynamicReference(new lib_1.CfnDynamicReference(lib_1.CfnDynamicReferenceService.Ssm, 'foo:bar'));
        // THEN
        test.deepEqual(stack.node.resolve(v), '{{resolve:ssm:foo:bar}}');
        test.done();
    },
    'cfnParameter (with NoEcho)'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String', noEcho: true });
        // WHEN
        const v = lib_1.SecretValue.cfnParameter(p);
        // THEN
        test.deepEqual(stack.node.resolve(v), { Ref: 'MyParam' });
        test.done();
    },
    'fails if cfnParameter does not have NoEcho'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        // THEN
        test.throws(() => lib_1.SecretValue.cfnParameter(p), /CloudFormation parameter must be configured with "NoEcho"/);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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