"use strict";
const lib_1 = require("../lib");
module.exports = {
    'Rule can be used to create rules'(test) {
        const stack = new lib_1.Stack();
        const rule = new lib_1.CfnRule(stack, 'MyRule');
        rule.addAssertion(lib_1.Fn.conditionEquals('lhs', 'rhs'), 'lhs equals rhs');
        rule.addAssertion(lib_1.Fn.conditionNot(lib_1.Fn.conditionAnd(lib_1.Fn.conditionContains(['hello', 'world'], "world"))), 'some assertion');
        test.deepEqual(stack._toCloudFormation(), {
            Rules: {
                MyRule: {
                    Assertions: [
                        {
                            Assert: { 'Fn::Equals': ['lhs', 'rhs'] },
                            AssertDescription: 'lhs equals rhs'
                        },
                        {
                            Assert: { 'Fn::Not': [{ 'Fn::And': [{ 'Fn::Contains': [['hello', 'world'], 'world'] }] }] },
                            AssertDescription: 'some assertion'
                        }
                    ]
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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