"use strict";
const lib_1 = require("../lib");
module.exports = {
    'parameters can be used and referenced using param.ref'(test) {
        const stack = new lib_1.Stack();
        const child = new lib_1.Construct(stack, 'Child');
        const param = new lib_1.CfnParameter(child, 'MyParam', {
            default: 10,
            type: 'Integer',
            description: 'My first parameter'
        });
        new lib_1.CfnResource(stack, 'Resource', { type: 'Type', properties: { ReferenceToParam: param.ref } });
        test.deepEqual(stack._toCloudFormation(), {
            Parameters: {
                ChildMyParam3161BF5D: {
                    Default: 10,
                    Type: 'Integer',
                    Description: 'My first parameter'
                }
            },
            Resources: {
                Resource: {
                    Type: 'Type',
                    Properties: { ReferenceToParam: { Ref: 'ChildMyParam3161BF5D' } }
                }
            }
        });
        test.done();
    },
    'parameters are tokens, so they can be assigned without .ref and their Ref will be taken'(test) {
        const stack = new lib_1.Stack();
        const param = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        test.deepEqual(stack.node.resolve(param), { Ref: 'MyParam' });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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