"use strict";
const lib_1 = require("../lib");
module.exports = {
    'outputs can be added to the stack'(test) {
        const stack = new lib_1.Stack();
        const res = new lib_1.CfnResource(stack, 'MyResource', { type: 'R' });
        const ref = res.ref;
        new lib_1.CfnOutput(stack, 'MyOutput', {
            export: 'ExportName',
            value: ref,
            description: 'CfnOutput properties'
        });
        test.deepEqual(stack._toCloudFormation(), { Resources: { MyResource: { Type: 'R' } },
            Outputs: { MyOutput: { Description: 'CfnOutput properties',
                    Export: { Name: 'ExportName' },
                    Value: { Ref: 'MyResource' } } } });
        test.done();
    },
    'outputs cannot be referenced'(test) {
        const stack = new lib_1.Stack();
        const output = new lib_1.CfnOutput(stack, 'MyOutput', { description: 'My CfnOutput', value: 'boom' });
        test.throws(() => output.ref);
        test.done();
    },
    'disableExport can be used to disable the auto-export behavior'(test) {
        const stack = new lib_1.Stack();
        const output = new lib_1.CfnOutput(stack, 'MyOutput', { disableExport: true, value: 'boom' });
        test.equal(output.export, null);
        // cannot specify `export` and `disableExport` at the same time.
        test.throws(() => new lib_1.CfnOutput(stack, 'YourOutput', {
            disableExport: true,
            export: 'bla',
            value: 'boom'
        }), /Cannot set `disableExport` and specify an export name/);
        test.done();
    },
    'if stack name is undefined, we will only use the logical ID for the export name'(test) {
        const stack = new lib_1.Stack();
        const output = new lib_1.CfnOutput(stack, 'MyOutput', { value: 'boom' });
        test.deepEqual(stack.node.resolve(output.makeImportValue()), { 'Fn::ImportValue': 'Stack:MyOutput' });
        test.done();
    },
    'makeImportValue can be used to create an Fn::ImportValue from an output'(test) {
        const stack = new lib_1.Stack(undefined, 'MyStack');
        const output = new lib_1.CfnOutput(stack, 'MyOutput', { value: 'boom' });
        test.deepEqual(stack.node.resolve(output.makeImportValue()), { 'Fn::ImportValue': 'MyStack:MyOutput' });
        test.deepEqual(stack._toCloudFormation(), {
            Outputs: {
                MyOutput: {
                    Value: 'boom',
                    Export: { Name: 'MyStack:MyOutput' }
                }
            }
        });
        test.done();
    },
    'No export is created by default'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        new lib_1.CfnOutput(stack, 'SomeOutput', { value: 'x' });
        // THEN
        test.deepEqual(stack._toCloudFormation(), {
            Outputs: {
                SomeOutput: {
                    Value: 'x'
                }
            }
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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