"use strict";
const lib_1 = require("../lib");
module.exports = {
    'mappings can be added as another type of entity, and mapping.findInMap can be used to get a token'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'MyMapping', { mapping: {
                TopLevelKey1: {
                    SecondLevelKey1: [1, 2, 3],
                    SecondLevelKey2: { Hello: 'World' }
                },
                TopLevelKey2: {
                    SecondLevelKey1: [99, 99, 99]
                }
            } });
        // findInMap can be used to take a reference
        new lib_1.CfnResource(stack, 'MyResource', {
            type: 'R',
            properties: {
                RefToValueInMap: mapping.findInMap('TopLevelKey1', 'SecondLevelKey1')
            }
        });
        test.throws(() => mapping.findInMap('NotFoundTopLevel', 'NotFound'), 'cant take a reference on a non existing key');
        test.throws(() => mapping.findInMap('TopLevelKey1', 'NotFound'), 'cant take a reference on a non existing key');
        // set value can be used to set/modify a specific value
        mapping.setValue('TopLevelKey2', 'SecondLevelKey2', 'Hi');
        mapping.setValue('TopLevelKey1', 'SecondLevelKey1', [1, 2, 3, 4]);
        test.deepEqual(stack._toCloudFormation(), { Mappings: { MyMapping: { TopLevelKey1: { SecondLevelKey1: [1, 2, 3, 4],
                        SecondLevelKey2: { Hello: 'World' } },
                    TopLevelKey2: { SecondLevelKey1: [99, 99, 99], SecondLevelKey2: 'Hi' } } },
            Resources: { MyResource: { Type: 'R',
                    Properties: { RefToValueInMap: { 'Fn::FindInMap': ['MyMapping', 'TopLevelKey1', 'SecondLevelKey1'] } } } } });
        test.done();
    },
    'allow using unresolved tokens in find-in-map'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                instanceCount: {
                    'us-east-1': 12
                }
            }
        });
        const v1 = mapping.findInMap('instanceCount', lib_1.Aws.region);
        const v2 = lib_1.Fn.findInMap(mapping.logicalId, 'instanceCount', lib_1.Aws.region);
        const expected = { 'Fn::FindInMap': ['mapping', 'instanceCount', { Ref: 'AWS::Region' }] };
        test.deepEqual(stack.node.resolve(v1), expected);
        test.deepEqual(stack.node.resolve(v2), expected);
        test.done();
    },
    'no validation if first key is token and second is a static string'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                'us-east-1': {
                    size: 12
                }
            }
        });
        // WHEN
        const v = mapping.findInMap(lib_1.Aws.region, 'size');
        // THEN
        test.deepEqual(stack.node.resolve(v), {
            "Fn::FindInMap": ['mapping', { Ref: "AWS::Region" }, "size"]
        });
        test.done();
    },
    'validate first key if it is a string and second is a token'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                size: {
                    'us-east-1': 12
                }
            }
        });
        // WHEN
        const v = mapping.findInMap('size', lib_1.Aws.region);
        // THEN
        test.throws(() => mapping.findInMap('not-found', lib_1.Aws.region), /Mapping doesn't contain top-level key 'not-found'/);
        test.deepEqual(stack.node.resolve(v), { 'Fn::FindInMap': ['mapping', 'size', { Ref: 'AWS::Region' }] });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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