"use strict";
const lib_1 = require("../lib");
const template = {
    Parameters: {
        MyParam: {
            Type: 'String',
            Default: 'Hello'
        }
    },
    Resources: {
        MyResource1: {
            Type: 'ResourceType1',
            Properties: {
                P1: 1,
                P2: 2,
            }
        },
        MyResource2: {
            Type: 'ResourceType2'
        }
    }
};
/**
 * @param obj an object to clone
 * @returns a deep clone of ``obj`.
 */
function clone(obj) {
    switch (typeof obj) {
        case 'object':
            if (Array.isArray(obj)) {
                return obj.map(elt => clone(elt));
            }
            else {
                const cloned = {};
                for (const key of Object.keys(obj)) {
                    cloned[key] = clone(obj[key]);
                }
                return cloned;
            }
        default:
            return obj;
    }
}
module.exports = {
    'the Include construct can be used to embed an existing template as-is into a stack'(test) {
        const stack = new lib_1.Stack();
        new lib_1.Include(stack, 'T1', { template: clone(template) });
        test.deepEqual(stack._toCloudFormation(), {
            Parameters: { MyParam: { Type: 'String', Default: 'Hello' } },
            Resources: {
                MyResource1: { Type: 'ResourceType1', Properties: { P1: 1, P2: 2 } },
                MyResource2: { Type: 'ResourceType2' }
            }
        });
        test.done();
    },
    'included templates can co-exist with elements created programmatically'(test) {
        const stack = new lib_1.Stack();
        new lib_1.Include(stack, 'T1', { template: clone(template) });
        new lib_1.CfnResource(stack, 'MyResource3', { type: 'ResourceType3', properties: { P3: 'Hello' } });
        new lib_1.CfnOutput(stack, 'MyOutput', { description: 'Out!', disableExport: true, value: 'hey' });
        new lib_1.CfnParameter(stack, 'MyParam2', { type: 'Integer' });
        test.deepEqual(stack._toCloudFormation(), {
            Parameters: {
                MyParam: { Type: 'String', Default: 'Hello' },
                MyParam2: { Type: 'Integer' }
            },
            Resources: {
                MyResource1: { Type: 'ResourceType1', Properties: { P1: 1, P2: 2 } },
                MyResource2: { Type: 'ResourceType2' },
                MyResource3: { Type: 'ResourceType3', Properties: { P3: 'Hello' } }
            },
            Outputs: {
                MyOutput: { Description: 'Out!', Value: 'hey' }
            }
        });
        test.done();
    },
    'exception is thrown in construction if an entity from an included template has the same id as a programmatic entity'(test) {
        const stack = new lib_1.Stack();
        new lib_1.Include(stack, 'T1', { template });
        new lib_1.CfnResource(stack, 'MyResource3', { type: 'ResourceType3', properties: { P3: 'Hello' } });
        new lib_1.CfnOutput(stack, 'MyOutput', { description: 'Out!', value: 'in' });
        new lib_1.CfnParameter(stack, 'MyParam', { type: 'Integer' }); // duplicate!
        test.throws(() => stack._toCloudFormation());
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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