"use strict";
const cx_api_1 = require("@aws-cdk/cx-api");
const lib_1 = require("../lib");
module.exports = {
    'By default, environment region and account are not defined'(test) {
        const stack = new lib_1.Stack();
        test.ok(stack.env);
        test.equal(stack.env.account, null);
        test.equal(stack.env.region, null);
        test.done();
    },
    'Default account and region can be set in context (`aws:cdk:toolkit:default-account` and `aws:cdk:toolkit:default-region`)'(test) {
        const app = new lib_1.App();
        app.node.setContext(cx_api_1.DEFAULT_ACCOUNT_CONTEXT_KEY, 'my-default-account');
        app.node.setContext(cx_api_1.DEFAULT_REGION_CONTEXT_KEY, 'my-default-region');
        const stack = new lib_1.Stack(app, 'my-stack');
        test.equal(stack.env.account, 'my-default-account');
        test.equal(stack.env.region, 'my-default-region');
        test.done();
    },
    'If only `env.region` or `env.account` are specified, defaults will be used for the other'(test) {
        const app = new lib_1.App();
        app.node.setContext(cx_api_1.DEFAULT_ACCOUNT_CONTEXT_KEY, 'my-default-account');
        app.node.setContext(cx_api_1.DEFAULT_REGION_CONTEXT_KEY, 'my-default-region');
        const stack1 = new lib_1.Stack(app, 'S1', { env: { region: 'only-region' } });
        const stack2 = new lib_1.Stack(app, 'S2', { env: { account: 'only-account' } });
        test.equal(stack1.env.account, 'my-default-account');
        test.equal(stack1.env.region, 'only-region');
        test.equal(stack2.env.account, 'only-account');
        test.equal(stack2.env.region, 'my-default-region');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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