"use strict";
const cdk = require("../lib");
module.exports = {
    'chain conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const param = new cdk.CfnParameter(stack, 'Param1', { type: 'String' });
        const cond1 = new cdk.CfnCondition(stack, 'Condition1', { expression: cdk.Fn.conditionEquals("a", "b") });
        const cond2 = new cdk.CfnCondition(stack, 'Condition2', { expression: cdk.Fn.conditionContains(["a", "b", "c"], "c") });
        const cond3 = new cdk.CfnCondition(stack, 'Condition3', { expression: cdk.Fn.conditionEquals(param, "hello") });
        // WHEN
        new cdk.CfnCondition(stack, 'Condition4', {
            expression: cdk.Fn.conditionOr(cond1, cond2, cdk.Fn.conditionNot(cond3))
        });
        // THEN
        test.deepEqual(stack._toCloudFormation(), {
            Parameters: { Param1: { Type: 'String' } },
            Conditions: {
                Condition1: { 'Fn::Equals': ['a', 'b'] },
                Condition2: { 'Fn::Contains': [['a', 'b', 'c'], 'c'] },
                Condition3: { 'Fn::Equals': [{ Ref: 'Param1' }, 'hello'] },
                Condition4: { 'Fn::Or': [
                        { Condition: 'Condition1' },
                        { Condition: 'Condition2' },
                        { 'Fn::Not': [{ Condition: 'Condition3' }] }
                    ] }
            }
        });
        test.done();
    },
    'condition expressions can be embedded as strings'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const propValue = cdk.Fn.conditionIf('Cond', 'A', 'B').toString();
        // WHEN
        new cdk.CfnResource(stack, 'MyResource', {
            type: 'AWS::Foo::Bar',
            properties: {
                StringProp: propValue
            }
        });
        // THEN
        test.ok(cdk.Token.isToken(propValue));
        test.deepEqual(stack._toCloudFormation(), {
            Resources: {
                MyResource: {
                    Type: 'AWS::Foo::Bar',
                    Properties: {
                        StringProp: { 'Fn::If': ['Cond', 'A', 'B'] }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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