"use strict";
const lib_1 = require("../lib");
const construct_1 = require("../lib/construct");
class MyConstruct extends construct_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
module.exports = {
    'Aspects are invoked only once'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        root.node.apply(new VisitOnce());
        root.node.prepareTree();
        test.deepEqual(root.visitCounter, 1);
        root.node.prepareTree();
        test.deepEqual(root.visitCounter, 1);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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