"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Simple function to evaluate CloudFormation intrinsics.
 *
 * Note that this function is not production quality, it exists to support tests.
 */
const instrinsics_1 = require("../lib/instrinsics");
function evaluateCFN(object, context = {}) {
    const intrinsics = {
        'Fn::Join'(separator, args) {
            return args.map(evaluate).join(separator);
        },
        'Ref'(logicalId) {
            if (!(logicalId in context)) {
                throw new Error(`Trying to evaluate Ref of '${logicalId}' but not in context!`);
            }
            return context[logicalId];
        },
        'Fn::GetAtt'(logicalId, attributeName) {
            const key = `${logicalId}.${attributeName}`;
            if (!(key in context)) {
                throw new Error(`Trying to evaluate Fn::GetAtt of '${logicalId}.${attributeName}' but not in context!`);
            }
            return context[key];
        }
    };
    return evaluate(object);
    function evaluate(obj) {
        if (Array.isArray(obj)) {
            return obj.map(evaluate);
        }
        if (typeof obj === 'object') {
            const keys = Object.keys(obj);
            if (keys.length === 1 && (instrinsics_1.isNameOfCloudFormationIntrinsic(keys[0]) || keys[0] === 'Ref')) {
                return evaluateIntrinsic(keys[0], obj[keys[0]]);
            }
            const ret = {};
            for (const key of keys) {
                ret[key] = evaluateCFN(obj[key]);
            }
            return ret;
        }
        return obj;
    }
    function evaluateIntrinsic(name, args) {
        if (!(name in intrinsics)) {
            throw new Error(`Intrinsic ${name} not supported here`);
        }
        if (!Array.isArray(args)) {
            args = [args];
        }
        return intrinsics[name].apply(intrinsics, args);
    }
}
exports.evaluateCFN = evaluateCFN;
//# sourceMappingURL=data:application/json;base64,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