import { TagType } from './cfn-resource';
/**
 * TagManager facilitates a common implementation of tagging for Constructs.
 */
export declare class TagManager {
    private readonly tags;
    private readonly priorities;
    private readonly tagFormatter;
    private readonly resourceTypeName;
    private readonly initialTagPriority;
    constructor(tagType: TagType, resourceTypeName: string, tagStructure?: any);
    /**
     * Adds the specified tag to the array of tags
     *
     */
    setTag(key: string, value: string, priority?: number, applyToLaunchedInstances?: boolean): void;
    /**
     * Removes the specified tag from the array if it exists
     *
     * @param key The tag to remove
     * @param priority The priority of the remove operation
     */
    removeTag(key: string, priority: number): void;
    /**
     * Renders tags into the proper format based on TagType
     */
    renderTags(): any;
    applyTagAspectHere(include?: string[], exclude?: string[]): boolean;
    private _setTag;
}
