"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cx_api_1 = require("@aws-cdk/cx-api");
const construct_1 = require("./construct");
class Synthesizer {
    synthesize(root, options = {}) {
        const session = new cx_api_1.CloudAssemblyBuilder(options.outdir);
        // the three holy phases of synthesis: prepare, validate and synthesize
        // prepare
        root.node.prepareTree();
        // validate
        const validate = options.skipValidation === undefined ? true : !options.skipValidation;
        if (validate) {
            const errors = root.node.validateTree();
            if (errors.length > 0) {
                const errorList = errors.map(e => `[${e.source.node.path}] ${e.message}`).join('\n  ');
                throw new Error(`Validation failed with the following errors:\n  ${errorList}`);
            }
        }
        // synthesize (leaves first)
        for (const c of root.node.findAll(construct_1.ConstructOrder.PostOrder)) {
            if (isSynthesizable(c)) {
                c.synthesize(session);
            }
        }
        // write session manifest and lock store
        return session.build(options);
    }
}
exports.Synthesizer = Synthesizer;
/**
 * @returns true if `obj` implements `ISynthesizable`.
 */
function isSynthesizable(obj) {
    return 'synthesize' in obj;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3ludGhlc2lzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3ludGhlc2lzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNENBQW9GO0FBQ3BGLDJDQUF5RDtBQW9CekQsTUFBYSxXQUFXO0lBQ2YsVUFBVSxDQUFDLElBQWdCLEVBQUUsVUFBNEIsRUFBRztRQUNqRSxNQUFNLE9BQU8sR0FBRyxJQUFJLDZCQUFvQixDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUV6RCx1RUFBdUU7UUFFdkUsVUFBVTtRQUNWLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7UUFFeEIsV0FBVztRQUNYLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxjQUFjLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQztRQUN2RixJQUFJLFFBQVEsRUFBRTtZQUNaLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDeEMsSUFBSSxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDckIsTUFBTSxTQUFTLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDdkYsTUFBTSxJQUFJLEtBQUssQ0FBQyxtREFBbUQsU0FBUyxFQUFFLENBQUMsQ0FBQzthQUNqRjtTQUNGO1FBRUQsNEJBQTRCO1FBQzVCLEtBQUssTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsMEJBQWMsQ0FBQyxTQUFTLENBQUMsRUFBRTtZQUMzRCxJQUFJLGVBQWUsQ0FBQyxDQUFDLENBQUMsRUFBRTtnQkFDdEIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQzthQUN2QjtTQUNGO1FBRUQsd0NBQXdDO1FBQ3hDLE9BQU8sT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNoQyxDQUFDO0NBQ0Y7QUE3QkQsa0NBNkJDO0FBRUQ7O0dBRUc7QUFDSCxTQUFTLGVBQWUsQ0FBQyxHQUFRO0lBQy9CLE9BQU8sWUFBWSxJQUFJLEdBQUcsQ0FBQztBQUM3QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQnVpbGRPcHRpb25zLCBDbG91ZEFzc2VtYmx5LCBDbG91ZEFzc2VtYmx5QnVpbGRlciB9IGZyb20gJ0Bhd3MtY2RrL2N4LWFwaSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3RPcmRlciwgSUNvbnN0cnVjdCB9IGZyb20gJy4vY29uc3RydWN0JztcblxuZXhwb3J0IGludGVyZmFjZSBJU3ludGhlc2l6YWJsZSB7XG4gIHN5bnRoZXNpemUoc2Vzc2lvbjogQ2xvdWRBc3NlbWJseUJ1aWxkZXIpOiB2b2lkO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFN5bnRoZXNpc09wdGlvbnMgZXh0ZW5kcyBCdWlsZE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGZpbGUgc3RvcmUgdXNlZCBmb3IgdGhpcyBzZXNzaW9uLlxuICAgKiBAZGVmYXVsdCAtIGNyZWF0ZXMgYSB0ZW1wb3JhcnkgZGlyZWN0b3J5XG4gICAqL1xuICByZWFkb25seSBvdXRkaXI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgc3ludGhlc2lzIHNob3VsZCBza2lwIHRoZSB2YWxpZGF0aW9uIHBoYXNlLlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgc2tpcFZhbGlkYXRpb24/OiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgU3ludGhlc2l6ZXIge1xuICBwdWJsaWMgc3ludGhlc2l6ZShyb290OiBJQ29uc3RydWN0LCBvcHRpb25zOiBTeW50aGVzaXNPcHRpb25zID0geyB9KTogQ2xvdWRBc3NlbWJseSB7XG4gICAgY29uc3Qgc2Vzc2lvbiA9IG5ldyBDbG91ZEFzc2VtYmx5QnVpbGRlcihvcHRpb25zLm91dGRpcik7XG5cbiAgICAvLyB0aGUgdGhyZWUgaG9seSBwaGFzZXMgb2Ygc3ludGhlc2lzOiBwcmVwYXJlLCB2YWxpZGF0ZSBhbmQgc3ludGhlc2l6ZVxuXG4gICAgLy8gcHJlcGFyZVxuICAgIHJvb3Qubm9kZS5wcmVwYXJlVHJlZSgpO1xuXG4gICAgLy8gdmFsaWRhdGVcbiAgICBjb25zdCB2YWxpZGF0ZSA9IG9wdGlvbnMuc2tpcFZhbGlkYXRpb24gPT09IHVuZGVmaW5lZCA/IHRydWUgOiAhb3B0aW9ucy5za2lwVmFsaWRhdGlvbjtcbiAgICBpZiAodmFsaWRhdGUpIHtcbiAgICAgIGNvbnN0IGVycm9ycyA9IHJvb3Qubm9kZS52YWxpZGF0ZVRyZWUoKTtcbiAgICAgIGlmIChlcnJvcnMubGVuZ3RoID4gMCkge1xuICAgICAgICBjb25zdCBlcnJvckxpc3QgPSBlcnJvcnMubWFwKGUgPT4gYFske2Uuc291cmNlLm5vZGUucGF0aH1dICR7ZS5tZXNzYWdlfWApLmpvaW4oJ1xcbiAgJyk7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgVmFsaWRhdGlvbiBmYWlsZWQgd2l0aCB0aGUgZm9sbG93aW5nIGVycm9yczpcXG4gICR7ZXJyb3JMaXN0fWApO1xuICAgICAgfVxuICAgIH1cblxuICAgIC8vIHN5bnRoZXNpemUgKGxlYXZlcyBmaXJzdClcbiAgICBmb3IgKGNvbnN0IGMgb2Ygcm9vdC5ub2RlLmZpbmRBbGwoQ29uc3RydWN0T3JkZXIuUG9zdE9yZGVyKSkge1xuICAgICAgaWYgKGlzU3ludGhlc2l6YWJsZShjKSkge1xuICAgICAgICBjLnN5bnRoZXNpemUoc2Vzc2lvbik7XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gd3JpdGUgc2Vzc2lvbiBtYW5pZmVzdCBhbmQgbG9jayBzdG9yZVxuICAgIHJldHVybiBzZXNzaW9uLmJ1aWxkKG9wdGlvbnMpO1xuICB9XG59XG5cbi8qKlxuICogQHJldHVybnMgdHJ1ZSBpZiBgb2JqYCBpbXBsZW1lbnRzIGBJU3ludGhlc2l6YWJsZWAuXG4gKi9cbmZ1bmN0aW9uIGlzU3ludGhlc2l6YWJsZShvYmo6IGFueSk6IG9iaiBpcyBJU3ludGhlc2l6YWJsZSB7XG4gIHJldHVybiAnc3ludGhlc2l6ZScgaW4gb2JqO1xufVxuIl19