import { BuildOptions, CloudAssembly, CloudAssemblyBuilder } from '@aws-cdk/cx-api';
import { IConstruct } from './construct';
export interface ISynthesizable {
    synthesize(session: CloudAssemblyBuilder): void;
}
export interface SynthesisOptions extends BuildOptions {
    /**
     * The file store used for this session.
     * @default - creates a temporary directory
     */
    readonly outdir?: string;
    /**
     * Whether synthesis should skip the validation phase.
     * @default false
     */
    readonly skipValidation?: boolean;
}
export declare class Synthesizer {
    synthesize(root: IConstruct, options?: SynthesisOptions): CloudAssembly;
}
