import { IFragmentConcatenator } from "./resolve";
import { Token } from "./token";
/**
 * Fragments of a string with markers
 */
export declare class TokenizedStringFragments {
    private readonly fragments;
    readonly firstToken: Token | undefined;
    readonly firstValue: any;
    readonly length: number;
    addLiteral(lit: any): void;
    addToken(token: Token): void;
    addIntrinsic(value: any): void;
    mapTokens(mapper: ITokenMapper): TokenizedStringFragments;
    /**
     * Combine the string fragments using the given joiner.
     *
     * If there are any
     */
    join(concat: IFragmentConcatenator): any;
}
/**
 * Interface to apply operation to tokens in a string
 *
 * Interface so it can be exported via jsii.
 */
export interface ITokenMapper {
    /**
     * Replace a single token
     */
    mapToken(t: Token): any;
}
