"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable-next-line:ban-types
function createStackTrace(below) {
    below = below || createStackTrace; // hide myself if nothing else
    const object = { stack: '' };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack.split('\n').slice(1).map(s => s.replace(/^\s*at\s+/, ''));
}
exports.createStackTrace = createStackTrace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQyxTQUFnQixnQkFBZ0IsQ0FBQyxLQUFnQjtJQUMvQyxLQUFLLEdBQUcsS0FBSyxJQUFJLGdCQUFnQixDQUFDLENBQUMsOEJBQThCO0lBQ2pFLE1BQU0sTUFBTSxHQUFHLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDO0lBQzdCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7SUFDNUMsSUFBSTtRQUNGLEtBQUssQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2hELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDeEM7WUFBUztRQUNSLEtBQUssQ0FBQyxlQUFlLEdBQUcsYUFBYSxDQUFDO0tBQ3ZDO0lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDakIsT0FBTyxFQUFFLENBQUM7S0FDWDtJQUNELE9BQU8sTUFBTSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDaEYsQ0FBQztBQWRELDRDQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOmJhbi10eXBlc1xuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZVN0YWNrVHJhY2UoYmVsb3c/OiBGdW5jdGlvbik6IHN0cmluZ1tdIHtcbiAgYmVsb3cgPSBiZWxvdyB8fCBjcmVhdGVTdGFja1RyYWNlOyAvLyBoaWRlIG15c2VsZiBpZiBub3RoaW5nIGVsc2VcbiAgY29uc3Qgb2JqZWN0ID0geyBzdGFjazogJycgfTtcbiAgY29uc3QgcHJldmlvdXNMaW1pdCA9IEVycm9yLnN0YWNrVHJhY2VMaW1pdDtcbiAgdHJ5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBOdW1iZXIuTUFYX1NBRkVfSU5URUdFUjtcbiAgICBFcnJvci5jYXB0dXJlU3RhY2tUcmFjZShvYmplY3QsIGJlbG93KTtcbiAgfSBmaW5hbGx5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBwcmV2aW91c0xpbWl0O1xuICB9XG4gIGlmICghb2JqZWN0LnN0YWNrKSB7XG4gICAgcmV0dXJuIFtdO1xuICB9XG4gIHJldHVybiBvYmplY3Quc3RhY2suc3BsaXQoJ1xcbicpLnNsaWNlKDEpLm1hcChzID0+IHMucmVwbGFjZSgvXlxccyphdFxccysvLCAnJykpO1xufVxuIl19