"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const token_1 = require("./token");
const REFERENCE_SYMBOL = Symbol.for('@aws-cdk/cdk.Reference');
/**
 * A Token that represents a reference between two constructs
 *
 * References are recorded.
 */
class Reference extends token_1.Token {
    /**
     * Check whether this is actually a Reference
     */
    static isReference(x) {
        return x[REFERENCE_SYMBOL] === true;
    }
    constructor(value, displayName, target) {
        super(value, displayName);
        this.target = target;
        Object.defineProperty(this, REFERENCE_SYMBOL, { value: true });
    }
}
exports.Reference = Reference;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVmZXJlbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVmZXJlbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQWdDO0FBRWhDLE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0FBRTlEOzs7O0dBSUc7QUFDSCxNQUFhLFNBQVUsU0FBUSxhQUFLO0lBQ2xDOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFdBQVcsQ0FBQyxDQUFRO1FBQ2hDLE9BQVEsQ0FBUyxDQUFDLGdCQUFnQixDQUFDLEtBQUssSUFBSSxDQUFDO0lBQy9DLENBQUM7SUFJRCxZQUFZLEtBQVUsRUFBRSxXQUFtQixFQUFFLE1BQWlCO1FBQzVELEtBQUssQ0FBQyxLQUFLLEVBQUUsV0FBVyxDQUFDLENBQUM7UUFDMUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFDckIsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUNqRSxDQUFDO0NBQ0Y7QUFmRCw4QkFlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuIH0gZnJvbSBcIi4vdG9rZW5cIjtcblxuY29uc3QgUkVGRVJFTkNFX1NZTUJPTCA9IFN5bWJvbC5mb3IoJ0Bhd3MtY2RrL2Nkay5SZWZlcmVuY2UnKTtcblxuLyoqXG4gKiBBIFRva2VuIHRoYXQgcmVwcmVzZW50cyBhIHJlZmVyZW5jZSBiZXR3ZWVuIHR3byBjb25zdHJ1Y3RzXG4gKlxuICogUmVmZXJlbmNlcyBhcmUgcmVjb3JkZWQuXG4gKi9cbmV4cG9ydCBjbGFzcyBSZWZlcmVuY2UgZXh0ZW5kcyBUb2tlbiB7XG4gIC8qKlxuICAgKiBDaGVjayB3aGV0aGVyIHRoaXMgaXMgYWN0dWFsbHkgYSBSZWZlcmVuY2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgaXNSZWZlcmVuY2UoeDogVG9rZW4pOiB4IGlzIFJlZmVyZW5jZSB7XG4gICAgcmV0dXJuICh4IGFzIGFueSlbUkVGRVJFTkNFX1NZTUJPTF0gPT09IHRydWU7XG4gIH1cblxuICBwdWJsaWMgcmVhZG9ubHkgdGFyZ2V0OiBDb25zdHJ1Y3Q7XG5cbiAgY29uc3RydWN0b3IodmFsdWU6IGFueSwgZGlzcGxheU5hbWU6IHN0cmluZywgdGFyZ2V0OiBDb25zdHJ1Y3QpIHtcbiAgICBzdXBlcih2YWx1ZSwgZGlzcGxheU5hbWUpO1xuICAgIHRoaXMudGFyZ2V0ID0gdGFyZ2V0O1xuICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0aGlzLCBSRUZFUkVOQ0VfU1lNQk9MLCB7IHZhbHVlOiB0cnVlIH0pO1xuICB9XG59XG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuL2NvbnN0cnVjdFwiO1xuIl19