"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_reference_1 = require("./cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * Accessor for pseudo parameters
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 */
class Aws {
    constructor() {
    }
    static get accountId() {
        return new UnscopedPseudo(AWS_ACCOUNTID).toString();
    }
    static get urlSuffix() {
        return new UnscopedPseudo(AWS_URLSUFFIX).toString();
    }
    static get notificationArns() {
        return new UnscopedPseudo(AWS_NOTIFICATIONARNS).toList();
    }
    static get partition() {
        return new UnscopedPseudo(AWS_PARTITION).toString();
    }
    static get region() {
        return new UnscopedPseudo(AWS_REGION).toString();
    }
    static get stackId() {
        return new UnscopedPseudo(AWS_STACKID).toString();
    }
    static get stackName() {
        return new UnscopedPseudo(AWS_STACKNAME).toString();
    }
    static get noValue() {
        return new UnscopedPseudo(AWS_NOVALUE).toString();
    }
}
exports.Aws = Aws;
/**
 * Accessor for scoped pseudo parameters
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 */
class ScopedAws {
    constructor(scope) {
        this.scope = scope;
    }
    get accountId() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_ACCOUNTID, this.scope).toString();
    }
    get urlSuffix() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_URLSUFFIX, this.scope).toString();
    }
    get notificationArns() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope).toList();
    }
    get partition() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_PARTITION, this.scope).toString();
    }
    get region() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_REGION, this.scope).toString();
    }
    get stackId() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_STACKID, this.scope).toString();
    }
    get stackName() {
        return cfn_reference_1.CfnReference.forPseudo(AWS_STACKNAME, this.scope).toString();
    }
}
exports.ScopedAws = ScopedAws;
class UnscopedPseudo extends token_1.Token {
    constructor(name) {
        super({ Ref: name }, name);
    }
}
//# sourceMappingURL=data:application/json;base64,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