import { Construct } from './construct';
/**
 * Accessor for pseudo parameters
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 */
export declare class Aws {
    private constructor();
    static readonly accountId: string;
    static readonly urlSuffix: string;
    static readonly notificationArns: string[];
    static readonly partition: string;
    static readonly region: string;
    static readonly stackId: string;
    static readonly stackName: string;
    static readonly noValue: string;
}
/**
 * Accessor for scoped pseudo parameters
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 */
export declare class ScopedAws {
    private readonly scope;
    constructor(scope: Construct);
    readonly accountId: string;
    readonly urlSuffix: string;
    readonly notificationArns: string[];
    readonly partition: string;
    readonly region: string;
    readonly stackId: string;
    readonly stackName: string;
}
