"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class Include extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param template The template to adopt.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.Include = Include;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5jbHVkZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImluY2x1ZGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwrQ0FBMkM7QUFVM0M7OztHQUdHO0FBQ0gsTUFBYSxPQUFRLFNBQVEsd0JBQVU7SUFNckM7Ozs7Ozs7T0FPRztJQUNILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDM0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7SUFDakMsQ0FBQztJQUVEOztPQUVHO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0NBQ0Y7QUF6QkQsMEJBeUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2ZuRWxlbWVudCB9IGZyb20gJy4vY2ZuLWVsZW1lbnQnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi9jb25zdHJ1Y3QnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEluY2x1ZGVQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gdGVtcGxhdGUgdG8gaW5jbHVkZSBpbiB0aGUgc3RhY2sgKGFzIGlzKS5cbiAgICovXG4gIHJlYWRvbmx5IHRlbXBsYXRlOiBvYmplY3Q7XG59XG5cbi8qKlxuICogSW5jbHVkZXMgYSBDbG91ZEZvcm1hdGlvbiB0ZW1wbGF0ZSBpbnRvIGEgc3RhY2suIEFsbCBlbGVtZW50cyBvZiB0aGUgdGVtcGxhdGUgd2lsbCBiZSBtZXJnZWQgaW50b1xuICogdGhlIGN1cnJlbnQgc3RhY2ssIHRvZ2V0aGVyIHdpdGggYW55IGVsZW1lbnRzIGNyZWF0ZWQgcHJvZ3JhbW1hdGljYWxseS5cbiAqL1xuZXhwb3J0IGNsYXNzIEluY2x1ZGUgZXh0ZW5kcyBDZm5FbGVtZW50IHtcbiAgLyoqXG4gICAqIFRoZSBpbmNsdWRlZCB0ZW1wbGF0ZS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0ZW1wbGF0ZTogb2JqZWN0O1xuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuIGFkb3B0ZWQgdGVtcGxhdGUgY29uc3RydWN0LiBUaGUgdGVtcGxhdGUgd2lsbCBiZSBpbmNvcnBvcmF0ZWQgaW50byB0aGUgc3RhY2sgYXMtaXMgd2l0aCBubyBjaGFuZ2VzIGF0IGFsbC5cbiAgICogVGhpcyBtZWFucyB0aGF0IGxvZ2ljYWwgSURzIG9mIGVudGl0aWVzIHdpdGhpbiB0aGlzIHRlbXBsYXRlIG1heSBjb25mbGljdCB3aXRoIGxvZ2ljYWwgSURzIG9mIGVudGl0aWVzIHRoYXQgYXJlIHBhcnQgb2YgdGhlXG4gICAqIHN0YWNrLlxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIHBhcmVudCBjb25zdHJ1Y3Qgb2YgdGhpcyB0ZW1wbGF0ZVxuICAgKiBAcGFyYW0gaWQgVGhlIElEIG9mIHRoaXMgY29uc3RydWN0XG4gICAqIEBwYXJhbSB0ZW1wbGF0ZSBUaGUgdGVtcGxhdGUgdG8gYWRvcHQuXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW5jbHVkZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLnRlbXBsYXRlID0gcHJvcHMudGVtcGxhdGU7XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX3RvQ2xvdWRGb3JtYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudGVtcGxhdGU7XG4gIH1cbn1cbiJdfQ==