import { Construct } from './construct';
declare type ContextProviderProps = {
    [key: string]: any;
};
/**
 * Base class for the model side of context providers
 *
 * Instances of this class communicate with context provider plugins in the 'cdk
 * toolkit' via context variables (input), outputting specialized queries for
 * more context variables (output).
 *
 * ContextProvider needs access to a Construct to hook into the context mechanism.
 */
export declare class ContextProvider {
    private readonly context;
    private readonly provider;
    private readonly props;
    constructor(context: Construct, provider: string, props?: ContextProviderProps);
    readonly key: string;
    /**
     * Read a provider value and verify it is not `null`
     */
    getValue(defaultValue: any): any;
    /**
     * Read a provider value, verifying it's a string
     * @param defaultValue The value to return if there is no value defined for this context key
     */
    getStringValue(defaultValue: string): string;
    /**
     * Read a provider value, verifying it's a list
     * @param defaultValue The value to return if there is no value defined for this context key
     */
    getStringListValue(defaultValue: string[]): string[];
}
/**
 * Context provider that will return the availability zones for the current account and region
 */
export declare class AvailabilityZoneProvider {
    private provider;
    constructor(context: Construct);
    /**
     * Return the list of AZs for the current account and region
     */
    readonly availabilityZones: string[];
}
export interface SSMParameterProviderProps {
    /**
     * The name of the parameter to lookup
     */
    readonly parameterName: string;
}
/**
 * Context provider that will read values from the SSM parameter store in the indicated account and region
 */
export declare class SSMParameterProvider {
    private provider;
    constructor(context: Construct, props: SSMParameterProviderProps);
    /**
     * Return the SSM parameter string with the indicated key
     */
    parameterValue(defaultValue?: string): any;
}
export {};
