import { CfnCondition } from './cfn-condition';
import { Construct, IConstruct } from './construct';
import { CreationPolicy, DeletionPolicy, UpdatePolicy } from './resource-policy';
import { TagManager } from './tag-manager';
import { CfnRefElement } from './cfn-element';
import { CfnReference } from './cfn-reference';
export interface CfnResourceProps {
    /**
     * CloudFormation resource type.
     */
    readonly type: string;
    /**
     * CloudFormation properties.
     *
     * @default - No resource properties.
     */
    readonly properties?: any;
}
export interface ITaggable {
    /**
     * TagManager to set, remove and format tags
     */
    readonly tags: TagManager;
}
/**
 * Represents a CloudFormation resource.
 */
export declare class CfnResource extends CfnRefElement {
    /**
     * A decoration used to create a CloudFormation attribute property.
     * @param customName Custom name for the attribute (default is the name of the property)
     * NOTE: we return "any" here to satistfy jsii, which doesn't support lambdas.
     */
    static attribute(customName?: string): any;
    /**
     * Check whether the given construct is a CfnResource
     */
    static isCfnResource(construct: IConstruct): construct is CfnResource;
    /**
     * Check whether the given construct is Taggable
     */
    static isTaggable(construct: any): construct is ITaggable;
    /**
     * Options for this resource, such as condition, update policy etc.
     */
    readonly options: IResourceOptions;
    /**
     * AWS resource type.
     */
    readonly resourceType: string;
    /**
     * AWS resource properties.
     *
     * This object is rendered via a call to "renderProperties(this.properties)".
     */
    protected readonly properties: any;
    /**
     * AWS resource property overrides.
     *
     * During synthesis, the method "renderProperties(this.overrides)" is called
     * with this object, and merged on top of the output of
     * "renderProperties(this.properties)".
     *
     * Derived classes should expose a strongly-typed version of this object as
     * a public property called `propertyOverrides`.
     */
    protected readonly untypedPropertyOverrides: any;
    /**
     * An object to be merged on top of the entire resource definition.
     */
    private readonly rawOverrides;
    /**
     * Logical IDs of dependencies.
     *
     * Is filled during prepare().
     */
    private readonly dependsOn;
    /**
     * Creates a resource construct.
     * @param resourceType The CloudFormation type of this resource (e.g. AWS::DynamoDB::Table)
     */
    constructor(scope: Construct, id: string, props: CfnResourceProps);
    /**
     * Returns a token for an runtime attribute of this resource.
     * Ideally, use generated attribute accessors (e.g. `resource.arn`), but this can be used for future compatibility
     * in case there is no generated attribute.
     * @param attributeName The name of the attribute.
     */
    getAtt(attributeName: string): CfnReference;
    /**
     * Adds an override to the synthesized CloudFormation resource. To add a
     * property override, either use `addPropertyOverride` or prefix `path` with
     * "Properties." (i.e. `Properties.TopicName`).
     *
     * @param path  The path of the property, you can use dot notation to
     *        override values in complex types. Any intermdediate keys
     *        will be created as needed.
     * @param value The value. Could be primitive or complex.
     */
    addOverride(path: string, value: any): void;
    /**
     * Syntactic sugar for `addOverride(path, undefined)`.
     * @param path The path of the value to delete
     */
    addDeletionOverride(path: string): void;
    /**
     * Adds an override to a resource property.
     *
     * Syntactic sugar for `addOverride("Properties.<...>", value)`.
     *
     * @param propertyPath The path of the property
     * @param value The value
     */
    addPropertyOverride(propertyPath: string, value: any): void;
    /**
     * Adds an override that deletes the value of a property from the resource definition.
     * @param propertyPath The path to the property.
     */
    addPropertyDeletionOverride(propertyPath: string): void;
    /**
     * Indicates that this resource depends on another resource and cannot be provisioned
     * unless the other resource has been successfully provisioned.
     */
    addDependsOn(resource: CfnResource): void;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
    protected validateProperties(_properties: any): void;
}
export declare enum TagType {
    Standard = "StandardTag",
    AutoScalingGroup = "AutoScalingGroupTag",
    Map = "StringToStringMap",
    NotTaggable = "NotTaggable"
}
export interface IResourceOptions {
    /**
     * A condition to associate with this resource. This means that only if the condition evaluates to 'true' when the stack
     * is deployed, the resource will be included. This is provided to allow CDK projects to produce legacy templates, but noramlly
     * there is no need to use it in CDK projects.
     */
    condition?: CfnCondition;
    /**
     * Associate the CreationPolicy attribute with a resource to prevent its status from reaching create complete until
     * AWS CloudFormation receives a specified number of success signals or the timeout period is exceeded. To signal a
     * resource, you can use the cfn-signal helper script or SignalResource API. AWS CloudFormation publishes valid signals
     * to the stack events so that you track the number of signals sent.
     */
    creationPolicy?: CreationPolicy;
    /**
     * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
     * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
     * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
     * that lead to resources being removed.
     */
    deletionPolicy?: DeletionPolicy;
    /**
     * Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup
     * resource. AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
     * scheduled action is associated with the Auto Scaling group.
     */
    updatePolicy?: UpdatePolicy;
    /**
     * Use the UpdateReplacePolicy attribute to retain or (in some cases) backup the existing physical instance of a resource
     * when it is replaced during a stack update operation.
     */
    updateReplacePolicy?: DeletionPolicy;
    /**
     * Metadata associated with the CloudFormation resource. This is not the same as the construct metadata which can be added
     * using construct.addMetadata(), but would not appear in the CloudFormation template automatically.
     */
    metadata?: {
        [key: string]: any;
    };
}
/**
 * Merges `source` into `target`, overriding any existing values.
 * `null`s will cause a value to be deleted.
 */
export declare function deepMerge(target: any, ...sources: any[]): any;
