"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const token_1 = require("./token");
/**
 * References a dynamically retrieved value
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 */
class CfnDynamicReference extends token_1.Token {
    constructor(service, key) {
        super(() => '{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
/**
 * The service to retrieve the dynamic reference from
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    /**
     * Plaintext value stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["Ssm"] = "ssm";
    /**
     * Secure string stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SsmSecure"] = "ssm-secure";
    /**
     * Secret stored in AWS Secrets Manager
     */
    CfnDynamicReferenceService["SecretsManager"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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