"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class CfnCondition extends cfn_element_1.CfnRefElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression
            }
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.CfnCondition = CfnCondition;
//# sourceMappingURL=data:application/json;base64,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