import { CloudAssembly } from '@aws-cdk/cx-api';
import { Construct } from './construct';
/**
 * Custom construction properties for a CDK program
 */
export interface AppProps {
    /**
     * Automatically call run before the application exits
     *
     * If you set this, you don't have to call `run()` anymore.
     *
     * @default true if running via CDK toolkit (CDK_OUTDIR is set), false otherwise
     */
    readonly autoRun?: boolean;
    /**
     * The output directory into which to emit synthesized artifacts.
     *
     * @default - If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.
     *            If `CDK_OUTDIR` is not defined, uses a temp directory.
     */
    readonly outdir?: string;
    /**
     * Include stack traces in construct metadata entries.
     * @default true stack traces are included
     */
    readonly stackTraces?: boolean;
    /**
     * Include runtime versioning information in cloud assembly manifest
     * @default true runtime info is included
     */
    readonly runtimeInfo?: boolean;
    /**
     * Additional context values for the application
     *
     * @default No additional context
     */
    readonly context?: {
        [key: string]: string;
    };
}
/**
 * Represents a CDK program.
 */
export declare class App extends Construct {
    static isApp(obj: any): obj is App;
    private _assembly?;
    private readonly runtimeInfo;
    private readonly outdir?;
    /**
     * Initializes a CDK application.
     * @param request Optional toolkit request (e.g. for tests)
     */
    constructor(props?: AppProps);
    /**
     * Runs the program. Output is written to output directory as specified in the
     * request.
     *
     * @returns a `CloudAssembly` which includes all the synthesized artifacts
     * such as CloudFormation templates and assets.
     */
    run(): CloudAssembly;
    private loadContext;
}
