# Generated by Django 2.0.9 on 2020-04-29 20:07

import assets.images.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='Category name')),
                ('item_name', models.CharField(blank=True, max_length=255, verbose_name='Item name')),
                ('logo', assets.images.models.LogoField(blank=True, editable=False, max_length=255, null=True, upload_to='categories', verbose_name='Logo')),
                ('description', models.TextField(blank=True, max_length=8192, null=True, verbose_name='Description')),
                ('grid', models.TextField(blank=True, max_length=4096, null=True, verbose_name='Size grid')),
                ('sex', models.PositiveSmallIntegerField(blank=True, choices=[(1, 'Male'), (2, 'Female'), (3, 'Both')], null=True, verbose_name='Sex')),
                ('age', models.CharField(blank=True, choices=[('adult', 'Adult'), ('child', 'Child')], max_length=100, verbose_name='Age')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ParentCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='Category name')),
            ],
            options={
                'verbose_name': 'Parent category',
                'verbose_name_plural': 'Parent categories',
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='category',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='categories.ParentCategory', verbose_name='Parent category'),
        ),
    ]
