/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.JUnitCore;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.TestSourceProvider;
import org.junit.vintage.engine.execution.RunListenerAdapter;
import org.junit.vintage.engine.execution.TestRun;

@API(status=API.Status.INTERNAL, since="4.12")
public class RunnerExecutor {
    private final EngineExecutionListener engineExecutionListener;
    private final TestSourceProvider testSourceProvider;

    public RunnerExecutor(EngineExecutionListener engineExecutionListener, TestSourceProvider testSourceProvider) {
        this.engineExecutionListener = engineExecutionListener;
        this.testSourceProvider = testSourceProvider;
    }

    public void execute(RunnerTestDescriptor runnerTestDescriptor) {
        TestRun testRun = new TestRun(runnerTestDescriptor);
        JUnitCore core = new JUnitCore();
        core.addListener(new RunListenerAdapter(testRun, this.engineExecutionListener, this.testSourceProvider));
        try {
            core.run(runnerTestDescriptor.toRequest());
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted(t);
            this.reportUnexpectedFailure(testRun, runnerTestDescriptor, TestExecutionResult.failed(t));
        }
    }

    private void reportUnexpectedFailure(TestRun testRun, RunnerTestDescriptor runnerTestDescriptor, TestExecutionResult result) {
        if (testRun.isNotStarted(runnerTestDescriptor)) {
            this.engineExecutionListener.executionStarted(runnerTestDescriptor);
        }
        this.engineExecutionListener.executionFinished(runnerTestDescriptor, result);
    }
}

