import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupBadgeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the group to add the badge to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge#group GroupBadge#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge#id GroupBadge#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The image url which will be presented on group overview.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge#image_url GroupBadge#image_url}
    */
    readonly imageUrl: string;
    /**
    * The url linked with the badge.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge#link_url GroupBadge#link_url}
    */
    readonly linkUrl: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge gitlab_group_badge}
*/
export declare class GroupBadge extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_badge";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_badge gitlab_group_badge} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupBadgeConfig
    */
    constructor(scope: Construct, id: string, config: GroupBadgeConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    get imageUrlInput(): string | undefined;
    private _linkUrl?;
    get linkUrl(): string;
    set linkUrl(value: string);
    get linkUrlInput(): string | undefined;
    get renderedImageUrl(): string;
    get renderedLinkUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group-badge.d.ts.map