#!/usr/bin/env python3

import logging
import urllib.parse
import datetime
import json

import requests
import pyjq

import abobjs

class AB_Continous_Monitoring_Monitor_Results(abobjs.AB_Base):

    _endpoint = "/api/v1/continuous_monitoring_monitor_results"
    _single = ".continuous_monitoring_monitor_results[0]"
    _name = "continuous_monitoring_monitor_result"

    _file_modal = "ContinuousMonitoringMonitorResult"
    _fileable_type = "ContinuousMonitoringMonitorResult"

    _uid_field = None
    _name_field = None

    def __init__(self, id=None, api_info=None, **kwargs):

        # Dunder Handling
        endpoint = kwargs.get("endpoint", self._endpoint)
        single = kwargs.get("single", self._single)
        name = kwargs.get("name", self._name)

        abobjs.AB_Base.__init__(self, id=id, api_info=api_info,
                                endpoint=endpoint, single=single, name=name,
                                **kwargs)
