from matplotlib.path import Path

import numpy as np

__all__ = ["rotate_marker", "atc_tower", "aircraft"]


def rotate_marker(path: Path, degrees: float) -> Path:
    angle = np.radians(degrees)
    newpath = path.vertices @ np.array(
        [[np.cos(angle), -np.sin(angle)], [np.sin(angle), np.cos(angle)]]
    )
    return Path(newpath, path.codes)


# fmt: off

# Markers are created from SVG files with the following command
# >>> from svgpath2mpl import parse_path
# >>> path = parse_path(svg)

atc_tower = Path(
    vertices=np.array(
        [
            [-17.59, 15.57], [-21.65, 33.82], [-18.77, 33.82], [-18.77, 37.67],
            [-1.98, 37.67], [-1.98, 43.56], [-7.03, 43.56], [-7.03, 49.0],
            [10.25, 49.0], [10.25, 43.56], [2.7, 43.56], [2.7, 37.68],
            [18.77, 37.68], [18.77, 33.83], [21.65, 33.83], [17.59, 15.58],
            [32.38, 15.58], [25.01, -7.54], [25.01, -7.54], [21.58, -9.18],
            [13.61, -10.2], [13.61, -49.0], [-13.61, -49.0], [-13.61, -10.28],
            [-21.75, -9.25], [-25.01, -7.55], [-25.01, -7.55], [-32.38, 15.57],
            [-17.59, 15.57], [-17.59, 15.57], [-13.76, 27.49], [-11.65, 18.0],
            [11.65, 18.0], [13.76, 27.49], [-13.76, 27.49], [-13.76, 27.49],
            [-21.54, -2.8], [21.54, -2.8], [25.89, 10.83], [-25.87, 10.83],
            [-21.54, -2.8], [-21.54, -2.8],
        ]
    ),
    codes=np.array(
        [
            1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2,
            2, 2, 4, 4, 4, 2, 2, 79, 1, 2, 2, 2, 2, 79, 1, 2, 2, 2, 2, 79,
        ],
        dtype=np.uint8,
    ),
)

aircraft = Path(
    vertices=np.array(
        [
            [-36.9805807, -17.69928568], [-31.821827, -16.29546868],
            [-14.25974384, -11.908985], [-6.9879194, -10.10230313],
            [-6.85361812, -16.1939292], [-6.23632725, -22.66151546],
            [-4.98652695, -28.40055259], [-8.83535437, -33.1500942],
            [-16.06191947, -42.2863559], [-16.34916643, -44.46514322],
            [-16.85296517, -48.20189406], [-15.98358392, -48.8786224],
            [-12.86573741, -47.21187042], [-9.7478909, -45.54511844],
            [0.59363779, -40.51228333], [0.59363779, -40.51228333],
            [0.59363779, -40.51228333], [10.87314422, -45.43312478],
            [13.976705, -47.07246716], [17.0751036, -48.70443718],
            [17.95830415, -48.02009167], [17.49106865, -44.29306108],
            [17.22164824, -42.11951245], [10.09577172, -33.05676861],
            [6.29281468, -28.34737006], [7.60221285, -22.60723919],
            [8.28774341, -16.11735222], [8.48301913, -10.02568025],
            [15.73100589, -11.76250749], [33.24709627, -15.95609197],
            [38.39148776, -17.30907433], [42.91282996, -18.49403707],
            [41.18555418, -14.91316911], [41.18555418, -14.91316911],
            [40.42368404, -13.26022903], [38.45829759, -9.96694463],
            [36.93263785, -8.76092003], [27.41072631, -1.26602826],
            [12.1763531, 10.04069137], [8.58529057, 12.69007883],
            [8.59238753, 14.67270301], [8.59798553, 16.83006915],
            [8.61313548, 19.22485003], [8.75691074, 45.69425366],
            [2.85440415, 48.20839169], [1.05684631, 48.20224287],
            [-0.7480839, 48.19093186], [-6.66905175, 45.61616243],
            [-6.81282701, 19.1467588], [-6.82797696, 16.75197791],
            [-6.83873715, 14.60198414], [-6.85320648, 12.61419778],
            [-10.46195786, 9.92251829], [-25.82218797, -1.54698376],
            [-35.42605141, -9.13965207], [-36.96611927, -10.36084982],
            [-38.96523935, -13.67238178], [-39.74876758, -15.33069825],
            [-39.74360539, -15.33807062], [-41.50895866, -18.93638312],
            [-36.9805807, -17.69928568], [-36.9805807, -17.69928568],
        ]
    ),
    codes=np.array(
        [
            1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 79,
        ],
        dtype=np.uint8,
    ),
)

# fmt: on
