"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_c = options.npmignoreEnabled) !== null && _c !== void 0 ? _c : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_d = options.gitignore) === null || _d === void 0 ? void 0 : _d.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_e = options.npmignore) === null || _e === void 0 ? void 0 : _e.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_f = this.npmignore) === null || _f === void 0 ? void 0 : _f.exclude(`/${common_1.PROJEN_RC}`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_h = options.projenDevDependency) !== null && _h !== void 0 ? _h : true;
        if (projen) {
            const projenVersion = (_j = options.projenVersion) !== null && _j !== void 0 ? _j : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const defaultReleaseBranch = (_k = options.defaultReleaseBranch) !== null && _k !== void 0 ? _k : 'main';
        // version is read from a committed file called version.json which is how we bump
        this._version = new version_1.Version(this, { releaseBranch: defaultReleaseBranch });
        this.package.addVersion(this._version.currentVersion);
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = ((_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true)) && ((_m = options.antitamper) !== null && _m !== void 0 ? _m : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_o = options.jest) !== null && _o !== void 0 ? _o : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_p = options.buildWorkflow) !== null && _p !== void 0 ? _p : (this.parent ? false : true)) {
            const { workflow, buildJobId } = this.createBuildWorkflow('Build', {
                trigger: {
                    pull_request: {},
                },
                image: options.workflowContainerImage,
                codeCov: (_q = options.codeCov) !== null && _q !== void 0 ? _q : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_r = options.releaseWorkflow) !== null && _r !== void 0 ? _r : (this.parent ? false : true)) {
            const releaseBranches = (_s = options.releaseBranches) !== null && _s !== void 0 ? _s : [defaultReleaseBranch];
            const trigger = {};
            if ((_t = options.releaseEveryCommit) !== null && _t !== void 0 ? _t : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_u = options.artifactsDirectory) !== null && _u !== void 0 ? _u : 'dist';
            const { workflow, buildJobId } = this.createBuildWorkflow('Release', {
                trigger,
                preBuildSteps: [{
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    }],
                pushBranch: '${{ github.ref }}',
                artifactDirectory,
                image: options.workflowContainerImage,
                codeCov: (_v = options.codeCov) !== null && _v !== void 0 ? _v : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_w = options.releaseToNpm) !== null && _w !== void 0 ? _w : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_x = options.mergify) !== null && _x !== void 0 ? _x : true) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_y = this.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('/.mergify.yml');
        }
        if ((_z = options.dependabot) !== null && _z !== void 0 ? _z : true) {
            (_0 = this.github) === null || _0 === void 0 ? void 0 : _0.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_1 = options.projenUpgradeAutoMerge) !== null && _1 !== void 0 ? _1 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_2 = this.autoMerge) === null || _2 === void 0 ? void 0 : _2.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_3 = options.pullRequestTemplate) !== null && _3 !== void 0 ? _3 : true) {
            (_4 = this.github) === null || _4 === void 0 ? void 0 : _4.addPullRequestTemplate(...(_5 = options.pullRequestTemplateContents) !== null && _5 !== void 0 ? _5 : []);
        }
        if ((_6 = options.rebuildBot) !== null && _6 !== void 0 ? _6 : (this.parent ? false : true)) {
            this.addRebuildBot((_7 = options.rebuildBotCommand) !== null && _7 !== void 0 ? _7 : 'rebuild');
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        // run "projen"
        install.push({
            name: 'Synthesize project files',
            run: this.package.projenCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e;
        const buildJobId = 'build';
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --exit-code',
            }];
        const commitChanges = !options.commit ? [] : [{
                name: 'Commit changes',
                run: `git commit -am "${options.commit}"`,
            }];
        const pushChanges = !options.pushBranch ? [] : [
            {
                name: 'Push commits',
                run: 'git push origin $BRANCH',
                env: {
                    BRANCH: options.pushBranch,
                },
            },
            // push tags only after we've managed to push our commits in order to
            // avoid tags being pushed but commits being rejected due to new commits
            // see https://github.com/projen/projen/issues/553
            {
                name: 'Push tags',
                run: 'git push --follow-tags origin $BRANCH',
                env: {
                    BRANCH: options.pushBranch,
                },
            },
        ];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Auto-bump"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_e = this.jest) === null || _e === void 0 ? void 0 : _e.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
                // if required, commit changes to the repo
                ...commitChanges,
                // push bump commit
                ...pushChanges,
                ...postSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        if (options.artifactDirectory) {
            job.steps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: options.artifactDirectory,
                    path: options.artifactDirectory,
                },
            });
        }
        workflow.addJobs({ [buildJobId]: job });
        return { workflow, buildJobId };
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
    addRebuildBot(command) {
        const postComment = (message) => ({
            name: 'Post comment to issue',
            uses: 'peter-evans/create-or-update-comment@v1',
            with: {
                'issue-number': '${{ github.event.issue.number }}',
                'body': `_projen_: ${message}`,
            },
        });
        this.createBuildWorkflow('rebuild-bot', {
            // trigger: { issue_comment: { types: ['created'] } }, // <--- disabled due to a security issue
            condition: `\${{ github.event.issue.pull_request && contains(github.event.comment.body, '@projen ${command}') }}`,
            antitamperDisabled: true,
            // since the "issue_comment" event is not triggered on a branch, we need to resolve
            // the git ref of the pull request before we check out
            preCheckoutSteps: [
                postComment('Rebuild started'),
                {
                    name: 'Get pull request branch',
                    id: 'query_pull_request',
                    env: { PULL_REQUEST_URL: '${{ github.event.issue.pull_request.url }}' },
                    run: [
                        'rm -f /tmp/pr.json',
                        'curl --silent $PULL_REQUEST_URL > /tmp/pr.json',
                        'BRANCH_STR=$(cat /tmp/pr.json | jq ".head.ref")',
                        'REPO_NAME=$(cat /tmp/pr.json | jq ".head.repo.full_name")',
                        'echo "::set-output name=branch::$(node -p $BRANCH_STR)"',
                        'echo "::set-output name=repo::$(node -p $REPO_NAME)"',
                    ].join('\n'),
                },
            ],
            // tell checkout to use the branch we acquired at the previous step
            checkoutWith: {
                ref: '${{ steps.query_pull_request.outputs.branch }}',
                repository: '${{ steps.query_pull_request.outputs.repo }}',
            },
            // commit changes
            commit: 'chore: update generated files',
            // and push to the pull request branch
            pushBranch: '${{ steps.query_pull_request.outputs.branch }}',
            postSteps: [
                postComment('Rebuild complete. Updates pushed to pull request branch.'),
            ],
        });
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.16.42" };
//# sourceMappingURL=data:application/json;base64,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