"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('empty file', () => {
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    new __1.TextFile(project, 'hello/foo.txt');
    // THEN
    const output = util_1.synthSnapshot(project)['hello/foo.txt'];
    expect(output).toEqual('');
});
test('initialized with some lines', () => {
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    new __1.TextFile(project, 'boom/boom/bam.txt', {
        lines: [
            'line1',
            'line2',
            'line3',
        ],
    });
    // THEN
    const output = util_1.synthSnapshot(project)['boom/boom/bam.txt'];
    expect(output).toEqual(['line1', 'line2', 'line3'].join('\n'));
});
test('addLine() can add lines later', () => {
    // GIVEN
    const project = new util_1.TestProject();
    const tf = new __1.TextFile(project, 'hello-world.txt', { lines: ['line1', 'line2'] });
    // WHEN
    tf.addLine('hey there');
    tf.addLine('you too');
    // THEN
    const output = util_1.synthSnapshot(project)['hello-world.txt'];
    expect(output).toEqual(['line1', 'line2', 'hey there', 'you too'].join('\n'));
});
//# sourceMappingURL=data:application/json;base64,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