##########################################################################
#
# Names that makes it easier to address individual data-columns.
# For example, you can write df[SGA] instead of
# df['Selling, General & Administrative'] to get the same data.
#
# For a better overview of the datasets and their data-columns, see:
# https://simfin.com/data/access/bulk
#
# This file was auto-generated by the script: tools/generate_names.py
#
##########################################################################
# SimFin - Simple financial data for Python.
# www.simfin.com - www.github.com/simfin/simfin
# See README.md for instructions and LICENSE.txt for license details.
##########################################################################

# Import all the extra names that have been manually defined. This makes
# them available for import through this auto-generated module as well.
from simfin.names_extra import *

##########################################################################

ABNORM_DERIV = 'Abnormal Derivatives'

ABNORM_GAIN_LOSS = 'Abnormal Gains (Losses)'

ACC_CHARGES = 'Accounting Charges & Other'

ACC_NOTES_RECV = 'Accounts & Notes Receivable'

ACCOUNTS_PAYABLE = 'Accounts Payable'

ACC_RECV_NET = 'Accounts Receivable, Net'

ACCR_INT_PAYABLE = 'Accrued Interest Payable'

ACCR_INT_RECV = 'Accrued Interest Receivable'

ACCRUED_LIAB = 'Accrued Liabilities'

ACCRUED_TAXES = 'Accrued Taxes'

ACCUM_DEPR = 'Accumulated Depreciation'

ACQ_IN_PROCESS_RD = 'Acquired In-Process R&D'

ACQ_FIX_ASSETS_INT = 'Acquisition of Fixed Assets & Intangibles'

ACQ_INT_ASSETS = 'Acquisition of Intangible Assets'

ADD_PAID_IN_CAPITAL = 'Additional Paid in Capital'

#: Daily share-price close adjusted for BOTH stock-splits AND dividends aka.
#: Total Return.
ADJ_CLOSE = SHARE_PRICE_ADJ_CLOSE = TOTAL_RETURN = 'Adj. Close'

ASSET_WRITEDOWN = 'Asset Write-Down'

ASSETS_HFS = 'Assets Held-for-Sale'

AUTO_LOANS = 'Auto Loans'

CAPEX = 'Capital Expenditures'

CASH_EQUIV = 'Cash & Cash Equivalents'

CASH_ACQ_SUB = 'Cash for Acquisition of Subsidiaries'

CASH_JOINT_VENTURES = 'Cash for Joint Ventures'

CASH_REPAY_DEBT = 'Cash from (Repayment of) Debt'

CASH_REPAY_LT_DEBT = 'Cash from (Repayment of) Long Term Debt, Net'

CASH_REPAY_ST_DEBT = 'Cash from (Repayment of) Short Term Debt, Net'

CASH_REPURCHASE_EQUITY = 'Cash from (Repurchase of) Equity'

CASH_LT_DEBT = 'Cash from Long Term Debt'

CASH_EQUIV_ST_INVEST = 'Cash, Cash Equivalents & Short Term Investments'

CHG_ACC_PAYABLE = 'Change in Accounts Payable'

CHG_ACCOUNTS_RECV = 'Change in Accounts Receivable'

CHG_CASH_DISCOP_OTHER = 'Change in Cash from Disc. Operations and Other'

CAPEX = CHG_FIX_ASSETS_INT = 'Change in Fixed Assets & Intangibles'

CHG_INSURANCE_RESERVES = 'Change in Insurance Reserves'

CHG_INVENTORIES = 'Change in Inventories'

CHG_OTHER = 'Change in Other'

CHG_WORKING_CAPITAL = 'Change in Working Capital'

CLAIMS_LOSSES = 'Claims & Losses'

#: Daily share-price close. Adjusted for stock-splits but NOT dividends. This is
#: used as the default share-price.
CLOSE = SHARE_PRICE = SHARE_PRICE_CLOSE = 'Close'

COMM_REAL_ESTATE_LOANS = 'Commercial Real Estate Loans'

COMM_FEES_EARNED = 'Commissions & Fees Earned'

COMM_FEES_PAID = 'Commissions & Fees Paid'

COMMON_STOCK = 'Common Stock'

#: Name of a company e.g. 'Microsoft'.
COMPANY_NAME = 'Company Name'

COST_FINANCING_REVENUE = 'Cost of Financing Revenue'

CGS = COST_GOODS_SERVICES = 'Cost of Goods & Services'

COST_OTHER_REVENUE = 'Cost of Other Revenue'

COST_REVENUE = 'Cost of Revenue'

CREDIT_CARD_LOANS = 'Credit Card Loans'

CREDIT_VALUE_ADJ = 'Credit Valuation Adjustment'

#: Currency for the data e.g. 'USD' for U.S. Dollar.
CURRENCY = 'Currency'

TAX_CURRENT = 'Current Income Tax'

CUR_PORT_LT_DEBT = 'Current Portion of Long Term Debt'

CUSTOMER_ACC_LIAB = 'Customer Acceptances & Liabilities'

#: Date associated with the given data e.g. share-prices.
DATE = 'Date'

DEBT_VALUE_ADJ = 'Debt Valuation Adjustment'

DECR_AFS_INVEST = 'Decrease in AFS Investments'

DECR_CAPITAL_STOCK = 'Decrease in Capital Stock'

DECR_HTM_INVEST = 'Decrease in HTM Investments'

DECR_INVEST = 'Decrease in Investments'

DECR_LT_INVEST = 'Decrease in Long Term Investment'

DEF_COMP = 'Deferred Compensation'

TAX_DEFERRED = 'Deferred Income Tax'

DEF_INCOME_TAXES = 'Deferred Income Taxes'

DEF_POLICY_ACQ_COST = 'Deferred Policy Acquisition Costs'

DEF_REVENUE_LT = 'Deferred Revenue (Long Term)'

DEF_REVENUE_ST = 'Deferred Revenue (Short Term)'

DEF_TAX_ASSETS_LT = 'Deferred Tax Assets (Long Term)'

DEF_TAX_ASSETS_ST = 'Deferred Tax Assets (Short Term)'

DEF_TAX_LIAB_LT = 'Deferred Tax Liabilities (Long Term)'

DEF_TAX_LIAB_ST = 'Deferred Tax Liabilities (Short Term)'

DEMAND_DEPOSITS = 'Demand Deposits'

DEPR_AMOR = 'Depreciation & Amortization'

DERIV_HEDG_ASSETS_LT = 'Derivative & Hedging Assets (Long Term)'

DERIV_HEDG_ASSETS_ST = 'Derivative & Hedging Assets (Short Term)'

DERIV_HEDG_ASSETS = 'Derivatives & Hedging (Assets)'

DERIV_HEDG_LIAB = 'Derivatives & Hedging (Liabilities)'

#: Net income from discontinued operations, net of taxes
DISCOP = 'Discontinued Operations'

DISCOP_ASSETS = 'Discontinued Operations (Assets)'

DISCOP_LIAB = 'Discontinued Operations (Liabilities)'

#: Non-current assets of discontinued operations
DISCOP_LT = 'Discontinued Operations (Long Term)'

#: Current assets of discontinued operations
DISCOP_ST = 'Discontinued Operations (Short Term)'

DISPOSAL_ASSETS = 'Disposal of Assets'

DISP_FIX_ASSETS = 'Disposition of Fixed Assets'

DISP_FIX_ASSETS_INT = 'Disposition of Fixed Assets & Intangibles'

DISP_INT_ASSETS = 'Disposition of Intangible Assets'

#: Dividends paid per share, before taxes. Adjusted for stock-splits.
DIVIDENDS = SHARE_DIVIDENDS = 'Dividend'

DIVIDENDS_PAID = 'Dividends Paid'

EARLY_EXT_DEBT = 'Early Extinguishment of Debt'

EFFECT_FX_RATES = 'Effect of Foreign Exchange Rates'

EQUITY_BEFORE_MINORITY = 'Equity Before Minority Interest'

EQUITY_SEC = 'Equity Securities'

FAMILY_RES_LOANS = 'Family Residential Loans'

FED_FUNDS_SOLD_REPOS = 'Fed Funds Sold & Repos'

FINANCING_REVENUE = 'Financing Revenue'

FINISHED_GOODS = 'Finished Goods'

#: Fiscal period for a financial report e.g. 'Q1' for the 1st Quarter.
FISCAL_PERIOD = 'Fiscal Period'

#: Fiscal year for a financial report. This may not equal the calendar year.
FISCAL_YEAR = 'Fiscal Year'

FIX_INCOME_HTM = 'Fixed Income Securities HTM'

FIX_INCOME_AFS = 'Fixed Income-Trading/AFS & Short Term Inv.'

FX = 'Foreign Exchange'

FX_GAIN_LOSS = 'Foreign Exchange Gain (Loss)'

FUNDS_FUT_APPR = 'Funds for Future Appropriations'

GAIN_SALE_SEC_LOANS = 'Gain On Sale of Securities & Loans'

GA = GEN_ADMIN = 'General & Administrative'

GOODWILL = 'Goodwill'

GROSS_PROFIT = 'Gross Profit'

#: Daily share-price high. Adjusted for stock-splits but NOT dividends.
HIGH = SHARE_PRICE_HIGH = 'High'

HOME_EQUITY_LOANS = 'Home Equity Loans'

IMPAIR_GOODWILL_INT = 'Impairment of Goodwill & Intangibles'

INCOME_INCL_MINORITY = 'Income (Loss) Incl. Minority Interest'

INCOME_AFFIL = 'Income (Loss) from Affiliates'

INCOME_AFFIL_NET_TAX = 'Income (Loss) from Affiliates, Net of Taxes'

INCOME_CONT_OP = 'Income (Loss) from Continuing Operations'

INCOME_TAX = 'Income Tax (Expense) Benefit, Net'

INCOME_TAX_RECV = 'Income Taxes Receivable'

INCOME_REAL_ESTATE = 'Income from Real Estate'

INCR_AFS_INVEST = 'Increase in AFS Investments'

INCR_CAPITAL_STOCK = 'Increase in Capital Stock'

INCR_HTM_INVEST = 'Increase in HTM Investments'

INCR_INVEST = 'Increase in Investments'

INCR_LT_INVEST = 'Increase in Long Term Investment'

#: Industry associated with IndustryId.
INDUSTRY = 'Industry'

#: Industry code of company. See 'industries' dataset for details.
INDUSTRY_ID = 'IndustryId'

INSURANCE_RESERVES = 'Insurance Reserves'

INSURANCE_SETTLEMENT = 'Insurance Settlement'

INTANGIBLES = 'Intangible Assets'

INTERBANK_ASSETS = 'Interbank Assets'

INT_DIV_PAYABLE = 'Interest & Dividends Payable'

INT_BEARING_DEPOSITS = 'Interest Bearing Deposits'

INTEREST_EXP = 'Interest Expense'

INTEREST_EXP_NET = 'Interest Expense, Net'

INTEREST_INCOME = 'Interest Income'

INVENTORIES = 'Inventories'

INVEST_INCOME = 'Investment Income (Loss)'

INVEST_SEC_AFS = 'Investment Securities Available for Sale'

INVEST_SEC_HTM = 'Investment Securities Held to Maturity'

INVEST_AFFIL = 'Investments in Affiliates'

INVEST_ASSOC = 'Investments in Associates'

LEGAL_SETTLEMENT = 'Legal Settlement'

LIAB_DERIV_HEDG_LT = 'Liabilities from Derivatives & Hedging (Long Term)'

LIAB_DERIV_HEDG_ST = 'Liabilities from Derivatives & Hedging (Short Term)'

LIAB_DISCOP_LT = 'Liabilities from Discontinued Operations (Long Term)'

LIAB_DISCOP_ST = 'Liabilities from Discontinued Operations (Short Term)'

LIFE_POLICY_BENEFITS = 'Life Policy Benefits'

LOANS_MORTGAGES = 'Loans & Mortgages'

LT_BORROWINGS = 'Long Term Borrowings'

LT_CAPITAL_LEASES = 'Long Term Capital Leases'

LT_CHARGES = 'Long Term Charges'

LT_DEBT = 'Long Term Debt'

LT_INVEST = 'Long Term Investments'

LT_INVEST_RECV = 'Long Term Investments & Receivables'

LT_MARKET_SEC = 'Long Term Marketable Securities'

LT_RECV = 'Long Term Receivables'

#: Daily share-price low. Adjusted for stock-splits but NOT dividends.
LOW = SHARE_PRICE_LOW = 'Low'

#: Name of market associated with MarketId
MARKET_NAME = 'Market Name'

#: Market ID
MARKET_ID = 'MarketId'

MERGER_ACQ_EXPENSE = 'Merger & Acquisition Expense'

MINORITY_INTEREST = 'Minority Interest'

MISC_LT_ASSETS = 'Misc. Long Term Assets'

MISC_LT_LIAB = 'Misc. Long Term Liabilities'

MISC_ST_ASSETS = 'Misc. Short Term Assets'

MISC_ST_LIAB = 'Misc. Short Term Liabilities'

NET_CASH_BEFORE_DISCOP_FX = 'Net Cash Before Disc. Operations and FX'

NET_CASH_BEFORE_FX = 'Net Cash Before FX'

NET_CASH_ACQ_DIVEST = 'Net Cash from Acquisitions & Divestitures'

NET_CASH_DISCOP_FIN = 'Net Cash from Discontinued Operations (Financing)'

NET_CASH_DISCOP_INVEST = 'Net Cash from Discontinued Operations (Investing)'

NET_CASH_DISCOP_OPER = 'Net Cash from Discontinued Operations (Operating)'

NET_CASH_DIVEST = 'Net Cash from Divestitures'

NET_CASH_FIN = 'Net Cash from Financing Activities'

NET_CASH_INV = 'Net Cash from Investing Activities'

NET_CASH_OPS = 'Net Cash from Operating Activities'

NET_CASH_OTHER_ACQ = 'Net Cash from Other Acquisitions'

NET_CHG_DEPOSITS = 'Net Change In Deposits'

NET_CHG_CASH = 'Net Change in Cash'

NET_CHG_CUSTOMER_LOANS = 'Net Change in Customer Loans'

NET_CHG_INTERBANK_ASSETS = 'Net Change in Interbank Assets'

NET_CHG_INTERBANK_TRANSFERS = 'Net Change in Interbank Transfers'

NET_CHG_INVEST = 'Net Change in Investments'

NET_CHG_LOANS_INTERBANK = 'Net Change in Loans & Interbank'

NET_CHG_LT_INVEST = 'Net Change in Long Term Investment'

NET_CHG_OP_LOANS = 'Net Change in Operating Loans'

NET_CHG_OTHER_INVEST = 'Net Change in Other Investments'

NET_CHG_OTHER_LOANS = 'Net Change in Other Loans'

NET_CHG_INTERBANK_ASSETS = 'Net Change of Interbank Assets'

NET_CHG_INTERBANK_LIAB = 'Net Change of Interbank Liabilities'

NET_CHG_INVEST = 'Net Change of Investments'

NET_EXTR_GAIN_LOSS = 'Net Extraordinary Gains (Losses)'

NET_FIX_ASSETS = 'Net Fixed Assets'

NET_INCOME = 'Net Income'

NET_INCOME_COMMON = 'Net Income (Common)'

NET_INCOME_DISCOP = 'Net Income from Discontinued Operations'

NET_INCOME_START = 'Net Income/Starting Line'

NET_INT_INCOME = 'Net Interest Income'

NET_INVEST_LOSS = 'Net Investment Losses'

NET_LOANS = 'Net Loans'

NET_OTTI_LOSS = 'Net OTTI Losses Recognised in Earnings'

NET_PREMIUMS_EARNED = 'Net Premiums Earned'

NET_REV_PROV = 'Net Revenue after Provisions'

NON_CASH_ITEMS = 'Non-Cash Items'

NON_OPERATING_INCOME = NON_OP_INCOME = 'Non-Operating Income (Loss)'

NOTES_RECV_NET = 'Notes Receivable, Net'

#: Daily share-price open. Adjusted for stock-splits but NOT dividends.
OPEN = SHARE_PRICE_OPEN = 'Open'

OPERATING_EXPENSES = OP_EXP = 'Operating Expenses'

OPERATING_INCOME = OP_INCOME = 'Operating Income (Loss)'

OP_LEASE_ASSETS = 'Operating Lease Assets'

OTHER_ABNORM = 'Other Abnormal Items'

OTHER_ADJ = 'Other Adjustments'

OTHER_ASSETS = 'Other Assets'

OTHER_CHG_FIX_ASSETS_INT = 'Other Change in Fixed Assets & Intangibles'

OTHER_CLAIMS_LOSSES = 'Other Claims & Losses'

OTHER_COMM_LOANS = 'Other Commercial Loans'

OTHER_CONSUMER_LOANS = 'Other Consumer Loans'

OTHER_DEPOSITS = 'Other Deposits'

OTHER_EQUITY = 'Other Equity'

OTHER_FIN_ACT = 'Other Financing Activities'

OTHER_FIX_ASSETS = 'Other Fixed Assets'

OTHER_INCOME = 'Other Income'

OTHER_INSURANCE_RESERVES = 'Other Insurance Reserves'

OTHER_INTANGIBLES = 'Other Intangible Assets'

OTHER_INTERBANK_ASSETS = 'Other Interbank Assets'

OTHER_INVENTORY = 'Other Inventory'

OTHER_INVEST_ACT = 'Other Investing Activities'

OTHER_INVEST_INCOME = 'Other Investment Income (Loss)'

OTHER_INVEST = 'Other Investments'

OTHER_LIAB = 'Other Liabilities'

OTHER_LOANS = 'Other Loans'

OTHER_LT_ASSETS = 'Other Long Term Assets'

OTHER_LT_LIAB = 'Other Long Term Liabilities'

OTHER_NON_CASH_ADJ = 'Other Non-Cash Adjustments'

OTHER_NON_INT_INCOME = 'Other Non-Interest Income'

OTHER_NON_OP_INCOME = 'Other Non-Operating Income (Loss)'

OTHER_OP_ASSETS_LIAB = 'Other Operating Assets/Liabilities'

OTHER_OP_EXPENSE = 'Other Operating Expenses'

#: (1) Other operating income includes revenue from all other operating
#: activities which are not related to the principal activities of the company.
#: (2) Other revenue
OTHER_OP_INCOME = 'Other Operating Income'

OTHER_PAYABLES = 'Other Payables & Accruals'

OTHER_POST_RET_BEN = 'Other Post-Retirement Benefits'

OTHER_REAL_INVEST_GAINS = 'Other Realized Investment Gains'

OTHER_REVENUE = 'Other Revenue'

OTHER_SHARE_CAPITAL = 'Other Share Capital'

OTHER_ST_ASSETS = 'Other Short Term Assets'

OTHER_ST_LIAB = 'Other Short Term Liabilities'

PAYABLES_ACCRUALS = 'Payables & Accruals'

PAYABLES_BROKER_DEALERS = 'Payables Broker Dealers'

PENSION_LIAB = 'Pension Liabilities'

PENSIONS = 'Pensions'

POLICY_CHARGES_FEES = 'Policy Charges & Fees'

POLICYHOLDERS_EQUITY = 'Policyholders Equity'

PREFERRED_DIVIDENDS = 'Preferred Dividends'

PREFERRED_EQUITY = 'Preferred Equity'

PREMIUM_RESERVE = 'Premium Reserve (Unearned)'

PREPAID_EXPENSE = 'Prepaid Expense'

PREPAID_EXPENSES = 'Prepaid Expenses'

PREPAID_PENSION_COSTS = 'Prepaid Pension Costs'

PRETAX_INCOME_LOSS = 'Pretax Income (Loss)'

PRETAX_INCOME_LOSS_ADJ = 'Pretax Income (Loss), Adj.'

PPE = PROP_PLANT_EQUIP = 'Property, Plant & Equipment'

PPE_NET = PROP_PLANT_EQUIP_NET = 'Property, Plant & Equipment, Net'

PROV_DOUBT_ACC = 'Provision for Doubtful Accounts'

PROV_LOAN_LOSSES = 'Provision for Loan Losses'

#: Date that a financial report was available to the market. Some financial
#: reports are restated and the standard datasets only use the newest data. For
#: example, if a financial report for the fiscal period 2012-12-31 is originally
#: published on e.g. 2013-01-21 but then restated on 2015-07-17 then this latter
#: date will be the one associated with the standard date. If you want the
#: original report and all restatements, you need to access the special dataset
#: designed for that.
PUBLISH_DATE = 'Publish Date'

PURCH_FIX_ASSETS = 'Purchase of Fixed Assets'

RAW_MATERIALS = 'Raw Materials'

REAL_ESTATE_INVEST = 'Real Estate Investments'

REPAY_LT_DEBT = 'Repayments of Long Term Debt'

#: Date printed in a financial report e.g. 2018-12-31. This is not the date the
#: information was available to the market, see PUBLISH_DATE for that.
REPORT_DATE = 'Report Date'

RD = RESEARCH_DEV = 'Research & Development'

RESERVE_LOAN_LOSS = 'Reserve for Loan Losses'

RESERVE_CLAIMS_LOSS = 'Reserve for Outstanding Claims & Losses'

RESTR_CHARGES = 'Restructuring Charges'

RETAINED_EARNINGS = 'Retained Earnings'

REVENUE = 'Revenue'

SALE_BUSINESS = 'Sale of Business'

SALE_INVESTMENTS = 'Sale of Investments & Unrealized Investments'

SALE_LOAN_INCOME = 'Sale of Loan Income (Loss)'

SALES_SERVICES_REVENUE = 'Sales & Services Revenue'

SAVING_DEPOSITS = 'Saving Deposits'

#: Sector associated with IndustryId.
SECTOR = 'Sector'

SEC_SOLD_REPO = 'Securities Sold Under Repo'

SELLING_MARKETING = 'Selling & Marketing'

SELLING_GEN_ADMIN = SGA = 'Selling, General & Administrative'

SHARE_CAPITAL_ADD = 'Share Capital & Additional Paid-In Capital'

#: Shares outstanding NOT adjusted for dilution from stock-options etc. Weighted
#: average for the period. Adjusted for stock-splits.
SHARES_BASIC = 'Shares (Basic)'

#: Shares outstanding adjusted for dilution from stock-options etc. Weighted
#: average for the period. Adjusted for stock-splits.
SHARES_DILUTED = 'Shares (Diluted)'

ST_LT_INVEST = 'Short & Long Term Investments'

ST_BORROWINGS = 'Short Term Borrowings'

ST_CAPITAL_LEASES = 'Short Term Capital Leases'

ST_DEBT = 'Short Term Debt'

ST_INVEST = 'Short Term Investments'

#: Unique ID for a company in the SimFin database. Useful if multiple companies
#: have the same ticker at different points in time, or if a company does not
#: have a ticker.
SIMFIN_ID = 'SimFinId'

#: Link to source of the financial statement.
SOURCE = 'Source'

STOCK_COMP = 'Stock-Based Compensation'

STUDENT_LOANS = 'Student Loans'

TAX_ALLOWANCE = 'Tax Allowance/Credit'

#: Ticker for identifying a stock e.g. MSFT for Microsoft.
TICKER = 'Ticker'

TIME_DEPOSITS = 'Time Deposits'

TOTAL_ASSETS = 'Total Assets'

TOTAL_CLAIMS_LOSSES = 'Total Claims & Losses'

TOTAL_COMM_LOANS = 'Total Commercial Loans'

TOTAL_CONSUMER_LOANS = 'Total Consumer Loans'

TOTAL_CUR_ASSETS = 'Total Current Assets'

TOTAL_CUR_LIAB = 'Total Current Liabilities'

TOTAL_DEPOSITS = 'Total Deposits'

TOTAL_EQUITY = 'Total Equity'

TOTAL_INT_EXPENSE = 'Total Interest Expense'

TOTAL_INT_INCOME = 'Total Interest Income'

TOTAL_INVEST = 'Total Investments'

TOTAL_LIAB = TOTAL_LIABILITIES = 'Total Liabilities'

TOTAL_LIAB_EQUITY = 'Total Liabilities & Equity'

TOTAL_LOANS = 'Total Loans'

TOTAL_NON_INT_EXPENSE = 'Total Non-Interest Expense'

TOTAL_NON_INT_INCOME = 'Total Non-Interest Income'

TOTAL_NONCUR_ASSETS = 'Total Noncurrent Assets'

TOTAL_NONCUR_LIAB = 'Total Noncurrent Liabilities'

TOTAL_OTTI_REALIZED = 'Total OTTI Realized'

REAL_INVEST_GAINS = 'Total Realized Investment Gains'

TRADING_ACC_LIAB = 'Trading Account Liabilities'

TRAD_ACC_PROFIT = 'Trading Account Profits/Losses'

TRADING_ASSETS_LIAB = 'Trading Assets & Liabilities'

TRADING_SECURITIES = 'Trading Securities'

TREASURY_STOCK = 'Treasury Stock'

UNBILLED_REVENUE = 'Unbilled Revenues'

UWRIT_EXP_ACQ_COST = 'Underwriting Expense & Acquisition Cost'

#: Number of shares traded during the day. Adjusted for stock-splits.
SHARE_VOLUME = VOLUME = 'Volume'

WORK_IN_PROCESS = 'Work In Process'

##########################################################################
