import enum
from typing import Any, List, Optional

# models

class QueryRequest:
    def __init__(self, metrics: List[str], ql: str): ...

class QueryResponse:
    def __init__(self, schema: Schema, rows: List[Row], affected_rows: int): ...
    def schema(self) -> Schema: ...
    def row_num(self) -> int: ...
    def get_row(self, idx: int) -> Optional[Row]: ...
    @property
    def affected_rows(self) -> int: ...

class ColumnSchema:
    def name(self) -> str: ...
    def data_type(self) -> ColumnDataType: ...

class ColumnDataType(enum.IntEnum):
    Null = 0
    TimestampMillis = 1
    Double = 2
    Float = 3
    Bytes = 4
    String = 5
    Int64 = 6
    Int32 = 7
    Boolean = 8

class Schema:
    def num_cols(self) -> int: ...
    def col_idx(self, name: str) -> Optional[int]: ...
    def get_column_schema(self, idx: int) -> Optional[ColumnSchema]: ...

class Row:
    def get_column_value(self, idx: int) -> Any: ...

class Value:
    pass

class ValueBuilder:
    def __init__(self): ...
    def with_i8(self, val: int): ...
    def with_u8(self, val: int): ...
    def with_i16(self, val: int): ...
    def with_u16(self, val: int): ...
    def with_i32(self, val: int): ...
    def with_u32(self, val: int): ...
    def with_i64(self, val: int): ...
    def with_u64(self, val: int): ...
    def with_float(self, val: float): ...
    def with_double(self, val: float): ...
    def with_bool(self, val: bool): ...
    def with_str(self, val: str): ...
    def with_varbinary(self, val: bytes): ...

class Point:
    pass

class PointBuilder:
    def __init__(self): ...
    def metric(self, metric: str): ...
    def timestamp(self, timestamp: int): ...
    def tag(self, name: str, val: Value): ...
    def field(self, name: str, val: Value): ...
    def build(self) -> Point: ...

class WriteRequest:
    def __init__(self): ...
    def add_point(self, point: Point): ...

class WriteReponse:
    def get_success(self) -> int: ...
    def get_failed(self) -> int: ...
    def get_metrics(self) -> List[str]: ...

# client

class RpcContext:
    def __init__(self, tenant: str, token: str): ...

class Client:
    def __init__(self, endpoint: str): ...
    async def query(self, ctx: RpcContext, req: QueryRequest) -> QueryResponse: ...
    async def write(self, ctx: RpcContext, req: WriteRequest) -> WriteReponse: ...

class GrpcConfig:
    def __init__(
        self,
        thread_num: int,
        max_send_msg_len: int,
        max_recv_msg_len: int,
        keepalive_time_ms: int,
        keepalive_timeout_ms: int,
    ): ...
    thread_num: int
    max_send_msg_len: int
    max_recv_msg_len: int
    keepalive_time_ms: int
    keepalive_timeout_ms: int

class RpcOptions:
    def __init__(self, write_timeout_ms: int, read_timeout_ms: int): ...
    write_timeout_ms: int
    read_timeout_ms: int

class Builder:
    def __init__(self, endpoint: str): ...
    def set_grpc_config(self, conf: GrpcConfig): ...
    def set_rpc_options(self, opts: RpcOptions): ...
    def build(self) -> Client: ...
